// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts.serde

import aws.sdk.kotlin.services.outposts.model.CapacityTaskFailure
import aws.sdk.kotlin.services.outposts.model.CapacityTaskStatus
import aws.sdk.kotlin.services.outposts.model.InstanceTypeCapacity
import aws.sdk.kotlin.services.outposts.model.OutpostsException
import aws.sdk.kotlin.services.outposts.model.StartCapacityTaskResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class StartCapacityTaskOperationDeserializer: HttpDeserializer.NonStreaming<StartCapacityTaskResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): StartCapacityTaskResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartCapacityTaskError(context, call, payload)
        }
        val builder = StartCapacityTaskResponse.Builder()

        if (payload != null) {
            deserializeStartCapacityTaskOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStartCapacityTaskError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw OutpostsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> OutpostsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartCapacityTaskOperationBody(builder: StartCapacityTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CAPACITYTASKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CapacityTaskId"))
    val CAPACITYTASKSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("CapacityTaskStatus"))
    val COMPLETIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CompletionDate"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationDate"))
    val DRYRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("DryRun"))
    val FAILED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Failed"))
    val LASTMODIFIEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedDate"))
    val ORDERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OrderId"))
    val OUTPOSTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OutpostId"))
    val REQUESTEDINSTANCEPOOLS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RequestedInstancePools"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAPACITYTASKID_DESCRIPTOR)
        field(CAPACITYTASKSTATUS_DESCRIPTOR)
        field(COMPLETIONDATE_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(DRYRUN_DESCRIPTOR)
        field(FAILED_DESCRIPTOR)
        field(LASTMODIFIEDDATE_DESCRIPTOR)
        field(ORDERID_DESCRIPTOR)
        field(OUTPOSTID_DESCRIPTOR)
        field(REQUESTEDINSTANCEPOOLS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CAPACITYTASKID_DESCRIPTOR.index -> builder.capacityTaskId = deserializeString()
                CAPACITYTASKSTATUS_DESCRIPTOR.index -> builder.capacityTaskStatus = deserializeString().let { CapacityTaskStatus.fromValue(it) }
                COMPLETIONDATE_DESCRIPTOR.index -> builder.completionDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DRYRUN_DESCRIPTOR.index -> builder.dryRun = deserializeBoolean()
                FAILED_DESCRIPTOR.index -> builder.failed = deserializeCapacityTaskFailureDocument(deserializer)
                LASTMODIFIEDDATE_DESCRIPTOR.index -> builder.lastModifiedDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ORDERID_DESCRIPTOR.index -> builder.orderId = deserializeString()
                OUTPOSTID_DESCRIPTOR.index -> builder.outpostId = deserializeString()
                REQUESTEDINSTANCEPOOLS_DESCRIPTOR.index -> builder.requestedInstancePools =
                    deserializer.deserializeList(REQUESTEDINSTANCEPOOLS_DESCRIPTOR) {
                        val col0 = mutableListOf<InstanceTypeCapacity>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInstanceTypeCapacityDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
