// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts.serde

import aws.sdk.kotlin.services.outposts.model.AssetState
import aws.sdk.kotlin.services.outposts.model.ListAssetsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class ListAssetsOperationSerializer: HttpSerialize<ListAssetsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListAssetsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.outpostIdentifier) { "outpostIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("outposts"))
                add(PercentEncoding.SmithyLabel.encode("${input.outpostIdentifier}"))
                add(PercentEncoding.Path.encode("assets"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.hostIdFilter?.isNotEmpty() == true) addAll("HostIdFilter", input.hostIdFilter)
                if (input.maxResults != null) add("MaxResults", "${input.maxResults}")
                if (input.nextToken != null) add("NextToken", input.nextToken)
                if (input.statusFilter?.isNotEmpty() == true) addAll("StatusFilter", input.statusFilter.map { "$it" })
            }
        }

        return builder
    }
}
