// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an order.
 */
public class Order private constructor(builder: Builder) {
    /**
     * The line items for the order
     */
    public val lineItems: List<LineItem>? = builder.lineItems
    /**
     * The fulfillment date of the order.
     */
    public val orderFulfilledDate: aws.smithy.kotlin.runtime.time.Instant? = builder.orderFulfilledDate
    /**
     * The ID of the order.
     */
    public val orderId: kotlin.String? = builder.orderId
    /**
     * The submission date for the order.
     */
    public val orderSubmissionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.orderSubmissionDate
    /**
     * The type of order.
     */
    public val orderType: aws.sdk.kotlin.services.outposts.model.OrderType? = builder.orderType
    /**
     * The ID of the Outpost in the order.
     */
    public val outpostId: kotlin.String? = builder.outpostId
    /**
     * The payment option for the order.
     */
    public val paymentOption: aws.sdk.kotlin.services.outposts.model.PaymentOption? = builder.paymentOption
    /**
     * The payment term.
     */
    public val paymentTerm: aws.sdk.kotlin.services.outposts.model.PaymentTerm? = builder.paymentTerm
    /**
     * The status of the order.
     * + `PREPARING` - Order is received and being prepared.
     * + `IN_PROGRESS` - Order is either being built, shipped, or installed. To get more details, see the line item status.
     * + `COMPLETED` - Order is complete.
     * + `CANCELLED` - Order is cancelled.
     * + `ERROR` - Customer should contact support.
     *
     * The following status are deprecated: `RECEIVED`, `PENDING`, `PROCESSING`, `INSTALLING`, and `FULFILLED`.
     */
    public val status: aws.sdk.kotlin.services.outposts.model.OrderStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.outposts.model.Order = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Order(")
        append("lineItems=$lineItems,")
        append("orderFulfilledDate=$orderFulfilledDate,")
        append("orderId=$orderId,")
        append("orderSubmissionDate=$orderSubmissionDate,")
        append("orderType=$orderType,")
        append("outpostId=$outpostId,")
        append("paymentOption=$paymentOption,")
        append("paymentTerm=$paymentTerm,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lineItems?.hashCode() ?: 0
        result = 31 * result + (orderFulfilledDate?.hashCode() ?: 0)
        result = 31 * result + (orderId?.hashCode() ?: 0)
        result = 31 * result + (orderSubmissionDate?.hashCode() ?: 0)
        result = 31 * result + (orderType?.hashCode() ?: 0)
        result = 31 * result + (outpostId?.hashCode() ?: 0)
        result = 31 * result + (paymentOption?.hashCode() ?: 0)
        result = 31 * result + (paymentTerm?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Order

        if (lineItems != other.lineItems) return false
        if (orderFulfilledDate != other.orderFulfilledDate) return false
        if (orderId != other.orderId) return false
        if (orderSubmissionDate != other.orderSubmissionDate) return false
        if (orderType != other.orderType) return false
        if (outpostId != other.outpostId) return false
        if (paymentOption != other.paymentOption) return false
        if (paymentTerm != other.paymentTerm) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.outposts.model.Order = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The line items for the order
         */
        public var lineItems: List<LineItem>? = null
        /**
         * The fulfillment date of the order.
         */
        public var orderFulfilledDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the order.
         */
        public var orderId: kotlin.String? = null
        /**
         * The submission date for the order.
         */
        public var orderSubmissionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of order.
         */
        public var orderType: aws.sdk.kotlin.services.outposts.model.OrderType? = null
        /**
         * The ID of the Outpost in the order.
         */
        public var outpostId: kotlin.String? = null
        /**
         * The payment option for the order.
         */
        public var paymentOption: aws.sdk.kotlin.services.outposts.model.PaymentOption? = null
        /**
         * The payment term.
         */
        public var paymentTerm: aws.sdk.kotlin.services.outposts.model.PaymentTerm? = null
        /**
         * The status of the order.
         * + `PREPARING` - Order is received and being prepared.
         * + `IN_PROGRESS` - Order is either being built, shipped, or installed. To get more details, see the line item status.
         * + `COMPLETED` - Order is complete.
         * + `CANCELLED` - Order is cancelled.
         * + `ERROR` - Customer should contact support.
         *
         * The following status are deprecated: `RECEIVED`, `PENDING`, `PROCESSING`, `INSTALLING`, and `FULFILLED`.
         */
        public var status: aws.sdk.kotlin.services.outposts.model.OrderStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.outposts.model.Order) : this() {
            this.lineItems = x.lineItems
            this.orderFulfilledDate = x.orderFulfilledDate
            this.orderId = x.orderId
            this.orderSubmissionDate = x.orderSubmissionDate
            this.orderType = x.orderType
            this.outpostId = x.outpostId
            this.paymentOption = x.paymentOption
            this.paymentTerm = x.paymentTerm
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.outposts.model.Order = Order(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
