// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts.paginators

import aws.sdk.kotlin.services.outposts.OutpostsClient
import aws.sdk.kotlin.services.outposts.model.AssetInfo
import aws.sdk.kotlin.services.outposts.model.CatalogItem
import aws.sdk.kotlin.services.outposts.model.GetOutpostInstanceTypesRequest
import aws.sdk.kotlin.services.outposts.model.GetOutpostInstanceTypesResponse
import aws.sdk.kotlin.services.outposts.model.InstanceTypeItem
import aws.sdk.kotlin.services.outposts.model.ListAssetsRequest
import aws.sdk.kotlin.services.outposts.model.ListAssetsResponse
import aws.sdk.kotlin.services.outposts.model.ListCatalogItemsRequest
import aws.sdk.kotlin.services.outposts.model.ListCatalogItemsResponse
import aws.sdk.kotlin.services.outposts.model.ListOrdersRequest
import aws.sdk.kotlin.services.outposts.model.ListOrdersResponse
import aws.sdk.kotlin.services.outposts.model.ListOutpostsRequest
import aws.sdk.kotlin.services.outposts.model.ListOutpostsResponse
import aws.sdk.kotlin.services.outposts.model.ListSitesRequest
import aws.sdk.kotlin.services.outposts.model.ListSitesResponse
import aws.sdk.kotlin.services.outposts.model.OrderSummary
import aws.sdk.kotlin.services.outposts.model.Outpost
import aws.sdk.kotlin.services.outposts.model.Site
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetOutpostInstanceTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetOutpostInstanceTypesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetOutpostInstanceTypesResponse]
 */
public fun OutpostsClient.getOutpostInstanceTypesPaginated(initialRequest: GetOutpostInstanceTypesRequest): Flow<GetOutpostInstanceTypesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getOutpostInstanceTypesPaginated.getOutpostInstanceTypes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetOutpostInstanceTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetOutpostInstanceTypesResponse]
 */
public fun OutpostsClient.getOutpostInstanceTypesPaginated(block: GetOutpostInstanceTypesRequest.Builder.() -> Unit): Flow<GetOutpostInstanceTypesResponse> =
    getOutpostInstanceTypesPaginated(GetOutpostInstanceTypesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getOutpostInstanceTypesPaginated]
 * to access the nested member [InstanceTypeItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [InstanceTypeItem]
 */
@JvmName("getOutpostInstanceTypesResponseInstanceTypeItem")
public fun Flow<GetOutpostInstanceTypesResponse>.instanceTypes(): Flow<InstanceTypeItem> =
    transform() { response ->
        response.instanceTypes?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAssetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssetsResponse]
 */
public fun OutpostsClient.listAssetsPaginated(initialRequest: ListAssetsRequest): Flow<ListAssetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssetsPaginated.listAssets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAssetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssetsResponse]
 */
public fun OutpostsClient.listAssetsPaginated(block: ListAssetsRequest.Builder.() -> Unit): Flow<ListAssetsResponse> =
    listAssetsPaginated(ListAssetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAssetsPaginated]
 * to access the nested member [AssetInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AssetInfo]
 */
@JvmName("listAssetsResponseAssetInfo")
public fun Flow<ListAssetsResponse>.assets(): Flow<AssetInfo> =
    transform() { response ->
        response.assets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCatalogItemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCatalogItemsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCatalogItemsResponse]
 */
public fun OutpostsClient.listCatalogItemsPaginated(initialRequest: ListCatalogItemsRequest): Flow<ListCatalogItemsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCatalogItemsPaginated.listCatalogItems(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCatalogItemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCatalogItemsResponse]
 */
public fun OutpostsClient.listCatalogItemsPaginated(block: ListCatalogItemsRequest.Builder.() -> Unit): Flow<ListCatalogItemsResponse> =
    listCatalogItemsPaginated(ListCatalogItemsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCatalogItemsPaginated]
 * to access the nested member [CatalogItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CatalogItem]
 */
@JvmName("listCatalogItemsResponseCatalogItem")
public fun Flow<ListCatalogItemsResponse>.catalogItems(): Flow<CatalogItem> =
    transform() { response ->
        response.catalogItems?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListOrdersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOrdersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOrdersResponse]
 */
public fun OutpostsClient.listOrdersPaginated(initialRequest: ListOrdersRequest): Flow<ListOrdersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listOrdersPaginated.listOrders(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListOrdersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOrdersResponse]
 */
public fun OutpostsClient.listOrdersPaginated(block: ListOrdersRequest.Builder.() -> Unit): Flow<ListOrdersResponse> =
    listOrdersPaginated(ListOrdersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listOrdersPaginated]
 * to access the nested member [OrderSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [OrderSummary]
 */
@JvmName("listOrdersResponseOrderSummary")
public fun Flow<ListOrdersResponse>.orders(): Flow<OrderSummary> =
    transform() { response ->
        response.orders?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListOutpostsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOutpostsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOutpostsResponse]
 */
public fun OutpostsClient.listOutpostsPaginated(initialRequest: ListOutpostsRequest): Flow<ListOutpostsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listOutpostsPaginated.listOutposts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListOutpostsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOutpostsResponse]
 */
public fun OutpostsClient.listOutpostsPaginated(block: ListOutpostsRequest.Builder.() -> Unit): Flow<ListOutpostsResponse> =
    listOutpostsPaginated(ListOutpostsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listOutpostsPaginated]
 * to access the nested member [Outpost]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Outpost]
 */
@JvmName("listOutpostsResponseOutpost")
public fun Flow<ListOutpostsResponse>.outposts(): Flow<Outpost> =
    transform() { response ->
        response.outposts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSitesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSitesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSitesResponse]
 */
public fun OutpostsClient.listSitesPaginated(initialRequest: ListSitesRequest): Flow<ListSitesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSitesPaginated.listSites(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSitesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSitesResponse]
 */
public fun OutpostsClient.listSitesPaginated(block: ListSitesRequest.Builder.() -> Unit): Flow<ListSitesResponse> =
    listSitesPaginated(ListSitesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSitesPaginated]
 * to access the nested member [Site]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Site]
 */
@JvmName("listSitesResponseSite")
public fun Flow<ListSitesResponse>.sites(): Flow<Site> =
    transform() { response ->
        response.sites?.forEach {
            emit(it)
        }
    }
