// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts.transform

import aws.sdk.kotlin.services.outposts.model.Address
import aws.sdk.kotlin.services.outposts.model.AddressType
import aws.sdk.kotlin.services.outposts.model.OutpostsException
import aws.sdk.kotlin.services.outposts.model.UpdateSiteAddressResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateSiteAddressOperationDeserializer: HttpDeserialize<UpdateSiteAddressResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateSiteAddressResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateSiteAddressError(context, call)
        }
        val builder = UpdateSiteAddressResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateSiteAddressOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateSiteAddressError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw OutpostsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> OutpostsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateSiteAddressOperationBody(builder: UpdateSiteAddressResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Address"))
    val ADDRESSTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AddressType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDRESS_DESCRIPTOR)
        field(ADDRESSTYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADDRESS_DESCRIPTOR.index -> builder.address = deserializeAddressDocument(deserializer)
                ADDRESSTYPE_DESCRIPTOR.index -> builder.addressType = deserializeString().let { AddressType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
