// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts.model



public class CreateSiteRequest private constructor(builder: Builder) {
    /**
     * The description of the site.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the site.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Additional information that you provide about site access requirements, electrician scheduling, personal protective equipment, or regulation of equipment materials that could affect your installation process.
     */
    public val notes: kotlin.String? = builder.notes
    /**
     * The location to install and power on the hardware. This address might be different from the shipping address.
     */
    public val operatingAddress: aws.sdk.kotlin.services.outposts.model.Address? = builder.operatingAddress
    /**
     * Information about the physical and logistical details for the rack at this site. For more information about hardware requirements for racks, see [Network readiness checklist](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist) in the Amazon Web Services Outposts User Guide.
     */
    public val rackPhysicalProperties: aws.sdk.kotlin.services.outposts.model.RackPhysicalProperties? = builder.rackPhysicalProperties
    /**
     * The location to ship the hardware. This address might be different from the operating address.
     */
    public val shippingAddress: aws.sdk.kotlin.services.outposts.model.Address? = builder.shippingAddress
    /**
     * The tags to apply to a site.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.outposts.model.CreateSiteRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSiteRequest(")
        append("description=$description,")
        append("name=$name,")
        append("notes=$notes,")
        append("operatingAddress=$operatingAddress,")
        append("rackPhysicalProperties=$rackPhysicalProperties,")
        append("shippingAddress=$shippingAddress,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notes?.hashCode() ?: 0)
        result = 31 * result + (operatingAddress?.hashCode() ?: 0)
        result = 31 * result + (rackPhysicalProperties?.hashCode() ?: 0)
        result = 31 * result + (shippingAddress?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSiteRequest

        if (description != other.description) return false
        if (name != other.name) return false
        if (notes != other.notes) return false
        if (operatingAddress != other.operatingAddress) return false
        if (rackPhysicalProperties != other.rackPhysicalProperties) return false
        if (shippingAddress != other.shippingAddress) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.outposts.model.CreateSiteRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The description of the site.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the site.
         */
        public var name: kotlin.String? = null
        /**
         * Additional information that you provide about site access requirements, electrician scheduling, personal protective equipment, or regulation of equipment materials that could affect your installation process.
         */
        public var notes: kotlin.String? = null
        /**
         * The location to install and power on the hardware. This address might be different from the shipping address.
         */
        public var operatingAddress: aws.sdk.kotlin.services.outposts.model.Address? = null
        /**
         * Information about the physical and logistical details for the rack at this site. For more information about hardware requirements for racks, see [Network readiness checklist](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist) in the Amazon Web Services Outposts User Guide.
         */
        public var rackPhysicalProperties: aws.sdk.kotlin.services.outposts.model.RackPhysicalProperties? = null
        /**
         * The location to ship the hardware. This address might be different from the operating address.
         */
        public var shippingAddress: aws.sdk.kotlin.services.outposts.model.Address? = null
        /**
         * The tags to apply to a site.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.outposts.model.CreateSiteRequest) : this() {
            this.description = x.description
            this.name = x.name
            this.notes = x.notes
            this.operatingAddress = x.operatingAddress
            this.rackPhysicalProperties = x.rackPhysicalProperties
            this.shippingAddress = x.shippingAddress
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.outposts.model.CreateSiteRequest = CreateSiteRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.outposts.model.Address] inside the given [block]
         */
        public fun operatingAddress(block: aws.sdk.kotlin.services.outposts.model.Address.Builder.() -> kotlin.Unit) {
            this.operatingAddress = aws.sdk.kotlin.services.outposts.model.Address.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.outposts.model.RackPhysicalProperties] inside the given [block]
         */
        public fun rackPhysicalProperties(block: aws.sdk.kotlin.services.outposts.model.RackPhysicalProperties.Builder.() -> kotlin.Unit) {
            this.rackPhysicalProperties = aws.sdk.kotlin.services.outposts.model.RackPhysicalProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.outposts.model.Address] inside the given [block]
         */
        public fun shippingAddress(block: aws.sdk.kotlin.services.outposts.model.Address.Builder.() -> kotlin.Unit) {
            this.shippingAddress = aws.sdk.kotlin.services.outposts.model.Address.invoke(block)
        }
    }
}
