// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.outposts.auth.DefaultOutpostsAuthSchemeProvider
import aws.sdk.kotlin.services.outposts.auth.OutpostsAuthSchemeProvider
import aws.sdk.kotlin.services.outposts.endpoints.DefaultOutpostsEndpointProvider
import aws.sdk.kotlin.services.outposts.endpoints.OutpostsEndpointParameters
import aws.sdk.kotlin.services.outposts.endpoints.OutpostsEndpointProvider
import aws.sdk.kotlin.services.outposts.model.CancelOrderRequest
import aws.sdk.kotlin.services.outposts.model.CancelOrderResponse
import aws.sdk.kotlin.services.outposts.model.CreateOrderRequest
import aws.sdk.kotlin.services.outposts.model.CreateOrderResponse
import aws.sdk.kotlin.services.outposts.model.CreateOutpostRequest
import aws.sdk.kotlin.services.outposts.model.CreateOutpostResponse
import aws.sdk.kotlin.services.outposts.model.CreateSiteRequest
import aws.sdk.kotlin.services.outposts.model.CreateSiteResponse
import aws.sdk.kotlin.services.outposts.model.DeleteOutpostRequest
import aws.sdk.kotlin.services.outposts.model.DeleteOutpostResponse
import aws.sdk.kotlin.services.outposts.model.DeleteSiteRequest
import aws.sdk.kotlin.services.outposts.model.DeleteSiteResponse
import aws.sdk.kotlin.services.outposts.model.GetCatalogItemRequest
import aws.sdk.kotlin.services.outposts.model.GetCatalogItemResponse
import aws.sdk.kotlin.services.outposts.model.GetConnectionRequest
import aws.sdk.kotlin.services.outposts.model.GetConnectionResponse
import aws.sdk.kotlin.services.outposts.model.GetOrderRequest
import aws.sdk.kotlin.services.outposts.model.GetOrderResponse
import aws.sdk.kotlin.services.outposts.model.GetOutpostInstanceTypesRequest
import aws.sdk.kotlin.services.outposts.model.GetOutpostInstanceTypesResponse
import aws.sdk.kotlin.services.outposts.model.GetOutpostRequest
import aws.sdk.kotlin.services.outposts.model.GetOutpostResponse
import aws.sdk.kotlin.services.outposts.model.GetSiteAddressRequest
import aws.sdk.kotlin.services.outposts.model.GetSiteAddressResponse
import aws.sdk.kotlin.services.outposts.model.GetSiteRequest
import aws.sdk.kotlin.services.outposts.model.GetSiteResponse
import aws.sdk.kotlin.services.outposts.model.ListAssetsRequest
import aws.sdk.kotlin.services.outposts.model.ListAssetsResponse
import aws.sdk.kotlin.services.outposts.model.ListCatalogItemsRequest
import aws.sdk.kotlin.services.outposts.model.ListCatalogItemsResponse
import aws.sdk.kotlin.services.outposts.model.ListOrdersRequest
import aws.sdk.kotlin.services.outposts.model.ListOrdersResponse
import aws.sdk.kotlin.services.outposts.model.ListOutpostsRequest
import aws.sdk.kotlin.services.outposts.model.ListOutpostsResponse
import aws.sdk.kotlin.services.outposts.model.ListSitesRequest
import aws.sdk.kotlin.services.outposts.model.ListSitesResponse
import aws.sdk.kotlin.services.outposts.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.outposts.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.outposts.model.StartConnectionRequest
import aws.sdk.kotlin.services.outposts.model.StartConnectionResponse
import aws.sdk.kotlin.services.outposts.model.TagResourceRequest
import aws.sdk.kotlin.services.outposts.model.TagResourceResponse
import aws.sdk.kotlin.services.outposts.model.UntagResourceRequest
import aws.sdk.kotlin.services.outposts.model.UntagResourceResponse
import aws.sdk.kotlin.services.outposts.model.UpdateOutpostRequest
import aws.sdk.kotlin.services.outposts.model.UpdateOutpostResponse
import aws.sdk.kotlin.services.outposts.model.UpdateSiteAddressRequest
import aws.sdk.kotlin.services.outposts.model.UpdateSiteAddressResponse
import aws.sdk.kotlin.services.outposts.model.UpdateSiteRackPhysicalPropertiesRequest
import aws.sdk.kotlin.services.outposts.model.UpdateSiteRackPhysicalPropertiesResponse
import aws.sdk.kotlin.services.outposts.model.UpdateSiteRequest
import aws.sdk.kotlin.services.outposts.model.UpdateSiteResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Outposts"
public const val SdkVersion: String = "0.32.1-beta"

/**
 * Amazon Web Services Outposts is a fully managed service that extends Amazon Web Services infrastructure, APIs, and tools to customer premises. By providing local access to Amazon Web Services managed infrastructure, Amazon Web Services Outposts enables customers to build and run applications on premises using the same programming interfaces as in Amazon Web Services Regions, while using local compute and storage resources for lower latency and local data processing needs.
 */
public interface OutpostsClient : SdkClient {
    /**
     * OutpostsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, OutpostsClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Outposts",
                "OUTPOSTS",
                "outposts",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, OutpostsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): OutpostsClient = DefaultOutpostsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        public val authSchemeProvider: OutpostsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultOutpostsAuthSchemeProvider
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: OutpostsEndpointProvider = builder.endpointProvider ?: DefaultOutpostsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemeProvider = this@Config.authSchemeProvider
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Outposts"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: OutpostsAuthSchemeProvider? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: OutpostsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels the specified order for an Outpost.
     */
    public suspend fun cancelOrder(input: CancelOrderRequest): CancelOrderResponse

    /**
     * Creates an order for an Outpost.
     */
    public suspend fun createOrder(input: CreateOrderRequest): CreateOrderResponse

    /**
     * Creates an Outpost.
     *
     * You can specify either an Availability one or an AZ ID.
     */
    public suspend fun createOutpost(input: CreateOutpostRequest): CreateOutpostResponse

    /**
     * Creates a site for an Outpost.
     */
    public suspend fun createSite(input: CreateSiteRequest): CreateSiteResponse

    /**
     * Deletes the specified Outpost.
     */
    public suspend fun deleteOutpost(input: DeleteOutpostRequest): DeleteOutpostResponse

    /**
     * Deletes the specified site.
     */
    public suspend fun deleteSite(input: DeleteSiteRequest): DeleteSiteResponse

    /**
     * Gets information about the specified catalog item.
     */
    public suspend fun getCatalogItem(input: GetCatalogItemRequest): GetCatalogItemResponse

    /**
     * Amazon Web Services uses this action to install Outpost servers.
     *
     *  Gets information about the specified connection.
     *
     *  Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to secure it. For more information, see [ Amazon Web Services managed policies for Amazon Web Services Outposts](https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html) and [ Logging Amazon Web Services Outposts API calls with Amazon Web Services CloudTrail](https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html) in the *Amazon Web Services Outposts User Guide*.
     */
    public suspend fun getConnection(input: GetConnectionRequest): GetConnectionResponse

    /**
     * Gets information about the specified order.
     */
    public suspend fun getOrder(input: GetOrderRequest): GetOrderResponse

    /**
     * Gets information about the specified Outpost.
     */
    public suspend fun getOutpost(input: GetOutpostRequest): GetOutpostResponse

    /**
     * Gets the instance types for the specified Outpost.
     */
    public suspend fun getOutpostInstanceTypes(input: GetOutpostInstanceTypesRequest): GetOutpostInstanceTypesResponse

    /**
     * Gets information about the specified Outpost site.
     */
    public suspend fun getSite(input: GetSiteRequest): GetSiteResponse

    /**
     * Gets the site address of the specified site.
     */
    public suspend fun getSiteAddress(input: GetSiteAddressRequest): GetSiteAddressResponse

    /**
     * Lists the hardware assets for the specified Outpost.
     *
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
     */
    public suspend fun listAssets(input: ListAssetsRequest): ListAssetsResponse

    /**
     * Lists the items in the catalog.
     *
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
     */
    public suspend fun listCatalogItems(input: ListCatalogItemsRequest = ListCatalogItemsRequest {}): ListCatalogItemsResponse

    /**
     * Lists the Outpost orders for your Amazon Web Services account.
     */
    public suspend fun listOrders(input: ListOrdersRequest = ListOrdersRequest {}): ListOrdersResponse

    /**
     * Lists the Outposts for your Amazon Web Services account.
     *
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
     */
    public suspend fun listOutposts(input: ListOutpostsRequest = ListOutpostsRequest {}): ListOutpostsResponse

    /**
     * Lists the Outpost sites for your Amazon Web Services account. Use filters to return specific results.
     *
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
     */
    public suspend fun listSites(input: ListSitesRequest = ListSitesRequest {}): ListSitesResponse

    /**
     * Lists the tags for the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Amazon Web Services uses this action to install Outpost servers.
     *
     *  Starts the connection required for Outpost server installation.
     *
     *  Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to secure it. For more information, see [ Amazon Web Services managed policies for Amazon Web Services Outposts](https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html) and [ Logging Amazon Web Services Outposts API calls with Amazon Web Services CloudTrail](https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html) in the *Amazon Web Services Outposts User Guide*.
     */
    public suspend fun startConnection(input: StartConnectionRequest): StartConnectionResponse

    /**
     * Adds tags to the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an Outpost.
     */
    public suspend fun updateOutpost(input: UpdateOutpostRequest): UpdateOutpostResponse

    /**
     * Updates the specified site.
     */
    public suspend fun updateSite(input: UpdateSiteRequest): UpdateSiteResponse

    /**
     * Updates the address of the specified site.
     *
     * You can't update a site address if there is an order in progress. You must wait for the order to complete or cancel the order.
     *
     * You can update the operating address before you place an order at the site, or after all Outposts that belong to the site have been deactivated.
     */
    public suspend fun updateSiteAddress(input: UpdateSiteAddressRequest): UpdateSiteAddressResponse

    /**
     * Update the physical and logistical details for a rack at a site. For more information about hardware requirements for racks, see [Network readiness checklist](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist) in the Amazon Web Services Outposts User Guide.
     *
     * To update a rack at a site with an order of `IN_PROGRESS`, you must wait for the order to complete or cancel the order.
     */
    public suspend fun updateSiteRackPhysicalProperties(input: UpdateSiteRackPhysicalPropertiesRequest): UpdateSiteRackPhysicalPropertiesResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun OutpostsClient.withConfig(block: OutpostsClient.Config.Builder.() -> Unit): OutpostsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultOutpostsClient(newConfig)
}

/**
 * Cancels the specified order for an Outpost.
 */
public suspend inline fun OutpostsClient.cancelOrder(crossinline block: CancelOrderRequest.Builder.() -> Unit): CancelOrderResponse = cancelOrder(CancelOrderRequest.Builder().apply(block).build())

/**
 * Creates an order for an Outpost.
 */
public suspend inline fun OutpostsClient.createOrder(crossinline block: CreateOrderRequest.Builder.() -> Unit): CreateOrderResponse = createOrder(CreateOrderRequest.Builder().apply(block).build())

/**
 * Creates an Outpost.
 *
 * You can specify either an Availability one or an AZ ID.
 */
public suspend inline fun OutpostsClient.createOutpost(crossinline block: CreateOutpostRequest.Builder.() -> Unit): CreateOutpostResponse = createOutpost(CreateOutpostRequest.Builder().apply(block).build())

/**
 * Creates a site for an Outpost.
 */
public suspend inline fun OutpostsClient.createSite(crossinline block: CreateSiteRequest.Builder.() -> Unit): CreateSiteResponse = createSite(CreateSiteRequest.Builder().apply(block).build())

/**
 * Deletes the specified Outpost.
 */
public suspend inline fun OutpostsClient.deleteOutpost(crossinline block: DeleteOutpostRequest.Builder.() -> Unit): DeleteOutpostResponse = deleteOutpost(DeleteOutpostRequest.Builder().apply(block).build())

/**
 * Deletes the specified site.
 */
public suspend inline fun OutpostsClient.deleteSite(crossinline block: DeleteSiteRequest.Builder.() -> Unit): DeleteSiteResponse = deleteSite(DeleteSiteRequest.Builder().apply(block).build())

/**
 * Gets information about the specified catalog item.
 */
public suspend inline fun OutpostsClient.getCatalogItem(crossinline block: GetCatalogItemRequest.Builder.() -> Unit): GetCatalogItemResponse = getCatalogItem(GetCatalogItemRequest.Builder().apply(block).build())

/**
 * Amazon Web Services uses this action to install Outpost servers.
 *
 *  Gets information about the specified connection.
 *
 *  Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to secure it. For more information, see [ Amazon Web Services managed policies for Amazon Web Services Outposts](https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html) and [ Logging Amazon Web Services Outposts API calls with Amazon Web Services CloudTrail](https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html) in the *Amazon Web Services Outposts User Guide*.
 */
public suspend inline fun OutpostsClient.getConnection(crossinline block: GetConnectionRequest.Builder.() -> Unit): GetConnectionResponse = getConnection(GetConnectionRequest.Builder().apply(block).build())

/**
 * Gets information about the specified order.
 */
public suspend inline fun OutpostsClient.getOrder(crossinline block: GetOrderRequest.Builder.() -> Unit): GetOrderResponse = getOrder(GetOrderRequest.Builder().apply(block).build())

/**
 * Gets information about the specified Outpost.
 */
public suspend inline fun OutpostsClient.getOutpost(crossinline block: GetOutpostRequest.Builder.() -> Unit): GetOutpostResponse = getOutpost(GetOutpostRequest.Builder().apply(block).build())

/**
 * Gets the instance types for the specified Outpost.
 */
public suspend inline fun OutpostsClient.getOutpostInstanceTypes(crossinline block: GetOutpostInstanceTypesRequest.Builder.() -> Unit): GetOutpostInstanceTypesResponse = getOutpostInstanceTypes(GetOutpostInstanceTypesRequest.Builder().apply(block).build())

/**
 * Gets information about the specified Outpost site.
 */
public suspend inline fun OutpostsClient.getSite(crossinline block: GetSiteRequest.Builder.() -> Unit): GetSiteResponse = getSite(GetSiteRequest.Builder().apply(block).build())

/**
 * Gets the site address of the specified site.
 */
public suspend inline fun OutpostsClient.getSiteAddress(crossinline block: GetSiteAddressRequest.Builder.() -> Unit): GetSiteAddressResponse = getSiteAddress(GetSiteAddressRequest.Builder().apply(block).build())

/**
 * Lists the hardware assets for the specified Outpost.
 *
 * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
 */
public suspend inline fun OutpostsClient.listAssets(crossinline block: ListAssetsRequest.Builder.() -> Unit): ListAssetsResponse = listAssets(ListAssetsRequest.Builder().apply(block).build())

/**
 * Lists the items in the catalog.
 *
 * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
 */
public suspend inline fun OutpostsClient.listCatalogItems(crossinline block: ListCatalogItemsRequest.Builder.() -> Unit): ListCatalogItemsResponse = listCatalogItems(ListCatalogItemsRequest.Builder().apply(block).build())

/**
 * Lists the Outpost orders for your Amazon Web Services account.
 */
public suspend inline fun OutpostsClient.listOrders(crossinline block: ListOrdersRequest.Builder.() -> Unit): ListOrdersResponse = listOrders(ListOrdersRequest.Builder().apply(block).build())

/**
 * Lists the Outposts for your Amazon Web Services account.
 *
 * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
 */
public suspend inline fun OutpostsClient.listOutposts(crossinline block: ListOutpostsRequest.Builder.() -> Unit): ListOutpostsResponse = listOutposts(ListOutpostsRequest.Builder().apply(block).build())

/**
 * Lists the Outpost sites for your Amazon Web Services account. Use filters to return specific results.
 *
 * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
 */
public suspend inline fun OutpostsClient.listSites(crossinline block: ListSitesRequest.Builder.() -> Unit): ListSitesResponse = listSites(ListSitesRequest.Builder().apply(block).build())

/**
 * Lists the tags for the specified resource.
 */
public suspend inline fun OutpostsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Amazon Web Services uses this action to install Outpost servers.
 *
 *  Starts the connection required for Outpost server installation.
 *
 *  Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to secure it. For more information, see [ Amazon Web Services managed policies for Amazon Web Services Outposts](https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html) and [ Logging Amazon Web Services Outposts API calls with Amazon Web Services CloudTrail](https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html) in the *Amazon Web Services Outposts User Guide*.
 */
public suspend inline fun OutpostsClient.startConnection(crossinline block: StartConnectionRequest.Builder.() -> Unit): StartConnectionResponse = startConnection(StartConnectionRequest.Builder().apply(block).build())

/**
 * Adds tags to the specified resource.
 */
public suspend inline fun OutpostsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from the specified resource.
 */
public suspend inline fun OutpostsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an Outpost.
 */
public suspend inline fun OutpostsClient.updateOutpost(crossinline block: UpdateOutpostRequest.Builder.() -> Unit): UpdateOutpostResponse = updateOutpost(UpdateOutpostRequest.Builder().apply(block).build())

/**
 * Updates the specified site.
 */
public suspend inline fun OutpostsClient.updateSite(crossinline block: UpdateSiteRequest.Builder.() -> Unit): UpdateSiteResponse = updateSite(UpdateSiteRequest.Builder().apply(block).build())

/**
 * Updates the address of the specified site.
 *
 * You can't update a site address if there is an order in progress. You must wait for the order to complete or cancel the order.
 *
 * You can update the operating address before you place an order at the site, or after all Outposts that belong to the site have been deactivated.
 */
public suspend inline fun OutpostsClient.updateSiteAddress(crossinline block: UpdateSiteAddressRequest.Builder.() -> Unit): UpdateSiteAddressResponse = updateSiteAddress(UpdateSiteAddressRequest.Builder().apply(block).build())

/**
 * Update the physical and logistical details for a rack at a site. For more information about hardware requirements for racks, see [Network readiness checklist](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist) in the Amazon Web Services Outposts User Guide.
 *
 * To update a rack at a site with an order of `IN_PROGRESS`, you must wait for the order to complete or cancel the order.
 */
public suspend inline fun OutpostsClient.updateSiteRackPhysicalProperties(crossinline block: UpdateSiteRackPhysicalPropertiesRequest.Builder.() -> Unit): UpdateSiteRackPhysicalPropertiesResponse = updateSiteRackPhysicalProperties(UpdateSiteRackPhysicalPropertiesRequest.Builder().apply(block).build())
