// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts.transform

import aws.sdk.kotlin.services.outposts.model.CatalogItem
import aws.sdk.kotlin.services.outposts.model.GetCatalogItemResponse
import aws.sdk.kotlin.services.outposts.model.OutpostsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetCatalogItemOperationDeserializer: HttpDeserialize<GetCatalogItemResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetCatalogItemResponse {
        if (!response.status.isSuccess()) {
            throwGetCatalogItemError(context, response)
        }
        val builder = GetCatalogItemResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetCatalogItemOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetCatalogItemError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OutpostsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OutpostsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCatalogItemOperationBody(builder: GetCatalogItemResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CATALOGITEM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CatalogItem"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CATALOGITEM_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CATALOGITEM_DESCRIPTOR.index -> builder.catalogItem = deserializeCatalogItemDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
