// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.transform

import aws.sdk.kotlin.services.organizations.model.Handshake
import aws.sdk.kotlin.services.organizations.model.InviteAccountToOrganizationResponse
import aws.sdk.kotlin.services.organizations.model.OrganizationsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class InviteAccountToOrganizationOperationDeserializer: HttpDeserialize<InviteAccountToOrganizationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): InviteAccountToOrganizationResponse {
        if (!response.status.isSuccess()) {
            throwInviteAccountToOrganizationError(context, response)
        }
        val builder = InviteAccountToOrganizationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeInviteAccountToOrganizationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwInviteAccountToOrganizationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OrganizationsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AccountOwnerNotVerifiedException" -> AccountOwnerNotVerifiedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AWSOrganizationsNotInUseException" -> AwsOrganizationsNotInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConstraintViolationException" -> ConstraintViolationExceptionDeserializer().deserialize(context, wrappedResponse)
        "DuplicateHandshakeException" -> DuplicateHandshakeExceptionDeserializer().deserialize(context, wrappedResponse)
        "FinalizingOrganizationException" -> FinalizingOrganizationExceptionDeserializer().deserialize(context, wrappedResponse)
        "HandshakeConstraintViolationException" -> HandshakeConstraintViolationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OrganizationsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeInviteAccountToOrganizationOperationBody(builder: InviteAccountToOrganizationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HANDSHAKE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Handshake"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HANDSHAKE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HANDSHAKE_DESCRIPTOR.index -> builder.handshake = deserializeHandshakeDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
