// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.transform

import aws.sdk.kotlin.services.organizations.model.EnablePolicyTypeResponse
import aws.sdk.kotlin.services.organizations.model.OrganizationsException
import aws.sdk.kotlin.services.organizations.model.Root
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class EnablePolicyTypeOperationDeserializer: HttpDeserialize<EnablePolicyTypeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): EnablePolicyTypeResponse {
        if (!response.status.isSuccess()) {
            throwEnablePolicyTypeError(context, response)
        }
        val builder = EnablePolicyTypeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeEnablePolicyTypeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwEnablePolicyTypeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OrganizationsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AWSOrganizationsNotInUseException" -> AwsOrganizationsNotInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConstraintViolationException" -> ConstraintViolationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "PolicyChangesInProgressException" -> PolicyChangesInProgressExceptionDeserializer().deserialize(context, wrappedResponse)
        "PolicyTypeAlreadyEnabledException" -> PolicyTypeAlreadyEnabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "PolicyTypeNotAvailableForOrganizationException" -> PolicyTypeNotAvailableForOrganizationExceptionDeserializer().deserialize(context, wrappedResponse)
        "RootNotFoundException" -> RootNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedAPIEndpointException" -> UnsupportedApiEndpointExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OrganizationsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeEnablePolicyTypeOperationBody(builder: EnablePolicyTypeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ROOT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Root"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ROOT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ROOT_DESCRIPTOR.index -> builder.root = deserializeRootDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
