// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.transform

import aws.sdk.kotlin.services.organizations.model.DescribeOrganizationalUnitResponse
import aws.sdk.kotlin.services.organizations.model.OrganizationalUnit
import aws.sdk.kotlin.services.organizations.model.OrganizationsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeOrganizationalUnitOperationDeserializer: HttpDeserialize<DescribeOrganizationalUnitResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeOrganizationalUnitResponse {
        if (!response.status.isSuccess()) {
            throwDescribeOrganizationalUnitError(context, response)
        }
        val builder = DescribeOrganizationalUnitResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeOrganizationalUnitOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeOrganizationalUnitError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OrganizationsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AWSOrganizationsNotInUseException" -> AwsOrganizationsNotInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "OrganizationalUnitNotFoundException" -> OrganizationalUnitNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OrganizationsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeOrganizationalUnitOperationBody(builder: DescribeOrganizationalUnitResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ORGANIZATIONALUNIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OrganizationalUnit"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ORGANIZATIONALUNIT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ORGANIZATIONALUNIT_DESCRIPTOR.index -> builder.organizationalUnit = deserializeOrganizationalUnitDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
