// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.transform

import aws.sdk.kotlin.services.organizations.model.AcceptHandshakeResponse
import aws.sdk.kotlin.services.organizations.model.Handshake
import aws.sdk.kotlin.services.organizations.model.OrganizationsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class AcceptHandshakeOperationDeserializer: HttpDeserialize<AcceptHandshakeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AcceptHandshakeResponse {
        if (!response.status.isSuccess()) {
            throwAcceptHandshakeError(context, response)
        }
        val builder = AcceptHandshakeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAcceptHandshakeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwAcceptHandshakeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OrganizationsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AccessDeniedForDependencyException" -> AccessDeniedForDependencyExceptionDeserializer().deserialize(context, wrappedResponse)
        "AWSOrganizationsNotInUseException" -> AwsOrganizationsNotInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedResponse)
        "HandshakeAlreadyInStateException" -> HandshakeAlreadyInStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "HandshakeConstraintViolationException" -> HandshakeConstraintViolationExceptionDeserializer().deserialize(context, wrappedResponse)
        "HandshakeNotFoundException" -> HandshakeNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidHandshakeTransitionException" -> InvalidHandshakeTransitionExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OrganizationsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAcceptHandshakeOperationBody(builder: AcceptHandshakeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HANDSHAKE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Handshake"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HANDSHAKE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HANDSHAKE_DESCRIPTOR.index -> builder.handshake = deserializeHandshakeDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
