// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model



/**
 * Contains information about a policy, but does not include the content. To see the content of a policy, see DescribePolicy.
 */
public class PolicySummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the policy.
     *
     * For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies) in the *Amazon Web Services Service Authorization Reference*.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A boolean value that indicates whether the specified policy is an Amazon Web Services managed policy. If true, then you can attach the policy to roots, OUs, or accounts, but you cannot edit it.
     */
    public val awsManaged: kotlin.Boolean = builder.awsManaged
    /**
     * The description of the policy.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The unique identifier (ID) of the policy.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
     */
    public val id: kotlin.String? = builder.id
    /**
     * The friendly name of the policy.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter is a string of any of the characters in the ASCII character range.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The type of policy.
     */
    public val type: aws.sdk.kotlin.services.organizations.model.PolicyType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.PolicySummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicySummary(")
        append("arn=$arn,")
        append("awsManaged=$awsManaged,")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (awsManaged.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicySummary

        if (arn != other.arn) return false
        if (awsManaged != other.awsManaged) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.PolicySummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the policy.
         *
         * For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies) in the *Amazon Web Services Service Authorization Reference*.
         */
        public var arn: kotlin.String? = null
        /**
         * A boolean value that indicates whether the specified policy is an Amazon Web Services managed policy. If true, then you can attach the policy to roots, OUs, or accounts, but you cannot edit it.
         */
        public var awsManaged: kotlin.Boolean = false
        /**
         * The description of the policy.
         */
        public var description: kotlin.String? = null
        /**
         * The unique identifier (ID) of the policy.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
         */
        public var id: kotlin.String? = null
        /**
         * The friendly name of the policy.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter is a string of any of the characters in the ASCII character range.
         */
        public var name: kotlin.String? = null
        /**
         * The type of policy.
         */
        public var type: aws.sdk.kotlin.services.organizations.model.PolicyType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.PolicySummary) : this() {
            this.arn = x.arn
            this.awsManaged = x.awsManaged
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.PolicySummary = PolicySummary(this)
    }
}
