// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model



/**
 * Contains information about either a root or an organizational unit (OU) that can contain OUs or accounts in an organization.
 */
public class Parent private constructor(builder: Builder) {
    /**
     * The unique identifier (ID) of the parent entity.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for a parent ID string requires one of the following:
     * + **Root** - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
     * + **Organizational unit (OU)** - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The type of the parent entity.
     */
    public val type: aws.sdk.kotlin.services.organizations.model.ParentType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.Parent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Parent(")
        append("id=$id,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Parent

        if (id != other.id) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.Parent = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier (ID) of the parent entity.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for a parent ID string requires one of the following:
         * + **Root** - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
         * + **Organizational unit (OU)** - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
         */
        public var id: kotlin.String? = null
        /**
         * The type of the parent entity.
         */
        public var type: aws.sdk.kotlin.services.organizations.model.ParentType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.Parent) : this() {
            this.id = x.id
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.Parent = Parent(this)
    }
}
