// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information that must be exchanged to securely establish a relationship between two accounts (an *originator* and a *recipient*). For example, when a management account (the originator) invites another account (the recipient) to join its organization, the two accounts exchange information as a series of handshake requests and responses.
 *
 * **Note:** Handshakes that are `CANCELED`, `ACCEPTED`, `DECLINED`, or `EXPIRED` show up in lists for only 30 days after entering that state After that they are deleted.
 */
public class Handshake private constructor(builder: Builder) {
    /**
     * The type of handshake, indicating what action occurs when the recipient accepts the handshake. The following handshake types are supported:
     * + **INVITE**: This type of handshake represents a request to join an organization. It is always sent from the management account to only non-member accounts.
     * + **ENABLE_ALL_FEATURES**: This type of handshake represents a request to enable all features in an organization. It is always sent from the management account to only *invited* member accounts. Created accounts do not receive this because those accounts were created by the organization's management account and approval is inferred.
     * + **APPROVE_ALL_FEATURES**: This type of handshake is sent from the Organizations service when all member accounts have approved the `ENABLE_ALL_FEATURES` invitation. It is sent only to the management account and signals the master that it can finalize the process to enable all features.
     */
    public val action: aws.sdk.kotlin.services.organizations.model.ActionType? = builder.action
    /**
     * The Amazon Resource Name (ARN) of a handshake.
     *
     * For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies) in the *Amazon Web Services Service Authorization Reference*.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time that the handshake expires. If the recipient of the handshake request fails to respond before the specified date and time, the handshake becomes inactive and is no longer valid.
     */
    public val expirationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationTimestamp
    /**
     * The unique identifier (ID) of a handshake. The originating account creates the ID when it initiates the handshake.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Information about the two accounts that are participating in the handshake.
     */
    public val parties: List<HandshakeParty>? = builder.parties
    /**
     * The date and time that the handshake request was made.
     */
    public val requestedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.requestedTimestamp
    /**
     * Additional information that is needed to process the handshake.
     */
    public val resources: List<HandshakeResource>? = builder.resources
    /**
     * The current state of the handshake. Use the state to trace the flow of the handshake through the process from its creation to its acceptance. The meaning of each of the valid values is as follows:
     * + **REQUESTED**: This handshake was sent to multiple recipients (applicable to only some handshake types) and not all recipients have responded yet. The request stays in this state until all recipients respond.
     * + **OPEN**: This handshake was sent to multiple recipients (applicable to only some policy types) and all recipients have responded, allowing the originator to complete the handshake action.
     * + **CANCELED**: This handshake is no longer active because it was canceled by the originating account.
     * + **ACCEPTED**: This handshake is complete because it has been accepted by the recipient.
     * + **DECLINED**: This handshake is no longer active because it was declined by the recipient account.
     * + **EXPIRED**: This handshake is no longer active because the originator did not receive a response of any kind from the recipient before the expiration time (15 days).
     */
    public val state: aws.sdk.kotlin.services.organizations.model.HandshakeState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.Handshake = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Handshake(")
        append("action=$action,")
        append("arn=$arn,")
        append("expirationTimestamp=$expirationTimestamp,")
        append("id=$id,")
        append("parties=$parties,")
        append("requestedTimestamp=$requestedTimestamp,")
        append("resources=$resources,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (expirationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (parties?.hashCode() ?: 0)
        result = 31 * result + (requestedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Handshake

        if (action != other.action) return false
        if (arn != other.arn) return false
        if (expirationTimestamp != other.expirationTimestamp) return false
        if (id != other.id) return false
        if (parties != other.parties) return false
        if (requestedTimestamp != other.requestedTimestamp) return false
        if (resources != other.resources) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.Handshake = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of handshake, indicating what action occurs when the recipient accepts the handshake. The following handshake types are supported:
         * + **INVITE**: This type of handshake represents a request to join an organization. It is always sent from the management account to only non-member accounts.
         * + **ENABLE_ALL_FEATURES**: This type of handshake represents a request to enable all features in an organization. It is always sent from the management account to only *invited* member accounts. Created accounts do not receive this because those accounts were created by the organization's management account and approval is inferred.
         * + **APPROVE_ALL_FEATURES**: This type of handshake is sent from the Organizations service when all member accounts have approved the `ENABLE_ALL_FEATURES` invitation. It is sent only to the management account and signals the master that it can finalize the process to enable all features.
         */
        public var action: aws.sdk.kotlin.services.organizations.model.ActionType? = null
        /**
         * The Amazon Resource Name (ARN) of a handshake.
         *
         * For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies) in the *Amazon Web Services Service Authorization Reference*.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time that the handshake expires. If the recipient of the handshake request fails to respond before the specified date and time, the handshake becomes inactive and is no longer valid.
         */
        public var expirationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier (ID) of a handshake. The originating account creates the ID when it initiates the handshake.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.
         */
        public var id: kotlin.String? = null
        /**
         * Information about the two accounts that are participating in the handshake.
         */
        public var parties: List<HandshakeParty>? = null
        /**
         * The date and time that the handshake request was made.
         */
        public var requestedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Additional information that is needed to process the handshake.
         */
        public var resources: List<HandshakeResource>? = null
        /**
         * The current state of the handshake. Use the state to trace the flow of the handshake through the process from its creation to its acceptance. The meaning of each of the valid values is as follows:
         * + **REQUESTED**: This handshake was sent to multiple recipients (applicable to only some handshake types) and not all recipients have responded yet. The request stays in this state until all recipients respond.
         * + **OPEN**: This handshake was sent to multiple recipients (applicable to only some policy types) and all recipients have responded, allowing the originator to complete the handshake action.
         * + **CANCELED**: This handshake is no longer active because it was canceled by the originating account.
         * + **ACCEPTED**: This handshake is complete because it has been accepted by the recipient.
         * + **DECLINED**: This handshake is no longer active because it was declined by the recipient account.
         * + **EXPIRED**: This handshake is no longer active because the originator did not receive a response of any kind from the recipient before the expiration time (15 days).
         */
        public var state: aws.sdk.kotlin.services.organizations.model.HandshakeState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.Handshake) : this() {
            this.action = x.action
            this.arn = x.arn
            this.expirationTimestamp = x.expirationTimestamp
            this.id = x.id
            this.parties = x.parties
            this.requestedTimestamp = x.requestedTimestamp
            this.resources = x.resources
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.Handshake = Handshake(this)
    }
}
