// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model



public class DetachPolicyRequest private constructor(builder: Builder) {
    /**
     * The unique identifier (ID) of the policy you want to detach. You can get the ID from the ListPolicies or ListPoliciesForTarget operations.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
     */
    public val policyId: kotlin.String? = builder.policyId
    /**
     * The unique identifier (ID) of the root, OU, or account that you want to detach the policy from. You can get the ID from the ListRoots, ListOrganizationalUnitsForParent, or ListAccounts operations.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for a target ID string requires one of the following:
     * + **Root** - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
     * + **Account** - A string that consists of exactly 12 digits.
     * + **Organizational unit (OU)** - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
     */
    public val targetId: kotlin.String? = builder.targetId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.DetachPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DetachPolicyRequest(")
        append("policyId=$policyId,")
        append("targetId=$targetId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = policyId?.hashCode() ?: 0
        result = 31 * result + (targetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DetachPolicyRequest

        if (policyId != other.policyId) return false
        if (targetId != other.targetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.DetachPolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier (ID) of the policy you want to detach. You can get the ID from the ListPolicies or ListPoliciesForTarget operations.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
         */
        public var policyId: kotlin.String? = null
        /**
         * The unique identifier (ID) of the root, OU, or account that you want to detach the policy from. You can get the ID from the ListRoots, ListOrganizationalUnitsForParent, or ListAccounts operations.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for a target ID string requires one of the following:
         * + **Root** - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
         * + **Account** - A string that consists of exactly 12 digits.
         * + **Organizational unit (OU)** - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
         */
        public var targetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.DetachPolicyRequest) : this() {
            this.policyId = x.policyId
            this.targetId = x.targetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.DetachPolicyRequest = DetachPolicyRequest(this)
    }
}
