// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about the delegated administrator.
 */
public class DelegatedAdministrator private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the delegated administrator's account.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date when the account was made a delegated administrator.
     */
    public val delegationEnabledDate: aws.smithy.kotlin.runtime.time.Instant? = builder.delegationEnabledDate
    /**
     * The email address that is associated with the delegated administrator's Amazon Web Services account.
     */
    public val email: kotlin.String? = builder.email
    /**
     * The unique identifier (ID) of the delegated administrator's account.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The method by which the delegated administrator's account joined the organization.
     */
    public val joinedMethod: aws.sdk.kotlin.services.organizations.model.AccountJoinedMethod? = builder.joinedMethod
    /**
     * The date when the delegated administrator's account became a part of the organization.
     */
    public val joinedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.joinedTimestamp
    /**
     * The friendly name of the delegated administrator's account.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The status of the delegated administrator's account in the organization.
     */
    public val status: aws.sdk.kotlin.services.organizations.model.AccountStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.DelegatedAdministrator = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DelegatedAdministrator(")
        append("arn=$arn,")
        append("delegationEnabledDate=$delegationEnabledDate,")
        append("email=*** Sensitive Data Redacted ***,")
        append("id=$id,")
        append("joinedMethod=$joinedMethod,")
        append("joinedTimestamp=$joinedTimestamp,")
        append("name=*** Sensitive Data Redacted ***,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (delegationEnabledDate?.hashCode() ?: 0)
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (joinedMethod?.hashCode() ?: 0)
        result = 31 * result + (joinedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DelegatedAdministrator

        if (arn != other.arn) return false
        if (delegationEnabledDate != other.delegationEnabledDate) return false
        if (email != other.email) return false
        if (id != other.id) return false
        if (joinedMethod != other.joinedMethod) return false
        if (joinedTimestamp != other.joinedTimestamp) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.DelegatedAdministrator = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the delegated administrator's account.
         */
        public var arn: kotlin.String? = null
        /**
         * The date when the account was made a delegated administrator.
         */
        public var delegationEnabledDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The email address that is associated with the delegated administrator's Amazon Web Services account.
         */
        public var email: kotlin.String? = null
        /**
         * The unique identifier (ID) of the delegated administrator's account.
         */
        public var id: kotlin.String? = null
        /**
         * The method by which the delegated administrator's account joined the organization.
         */
        public var joinedMethod: aws.sdk.kotlin.services.organizations.model.AccountJoinedMethod? = null
        /**
         * The date when the delegated administrator's account became a part of the organization.
         */
        public var joinedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The friendly name of the delegated administrator's account.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the delegated administrator's account in the organization.
         */
        public var status: aws.sdk.kotlin.services.organizations.model.AccountStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.DelegatedAdministrator) : this() {
            this.arn = x.arn
            this.delegationEnabledDate = x.delegationEnabledDate
            this.email = x.email
            this.id = x.id
            this.joinedMethod = x.joinedMethod
            this.joinedTimestamp = x.joinedTimestamp
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.DelegatedAdministrator = DelegatedAdministrator(this)
    }
}
