// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.organizations.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.organizations.model.OrganizationsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class DeleteResourcePolicyOperationDeserializer: HttpDeserialize<DeleteResourcePolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteResourcePolicyResponse {
        if (!response.status.isSuccess()) {
            throwDeleteResourcePolicyError(context, response)
        }
        val builder = DeleteResourcePolicyResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDeleteResourcePolicyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OrganizationsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AWSOrganizationsNotInUseException" -> AwsOrganizationsNotInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConstraintViolationException" -> ConstraintViolationExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourcePolicyNotFoundException" -> ResourcePolicyNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedAPIEndpointException" -> UnsupportedApiEndpointExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OrganizationsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
