// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model



public class UpdatePolicyRequest private constructor(builder: Builder) {
    /**
     * If provided, the new content for the policy. The text must be correctly formatted JSON that complies with the syntax for the policy's type. For more information, see [Service Control Policy Syntax](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html) in the *Organizations User Guide.*
     */
    public val content: kotlin.String? = builder.content
    /**
     * If provided, the new description for the policy.
     */
    public val description: kotlin.String? = builder.description
    /**
     * If provided, the new name for the policy.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter is a string of any of the characters in the ASCII character range.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The unique identifier (ID) of the policy that you want to update.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
     */
    public val policyId: kotlin.String? = builder.policyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.UpdatePolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdatePolicyRequest(")
        append("content=$content,")
        append("description=$description,")
        append("name=$name,")
        append("policyId=$policyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (policyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdatePolicyRequest

        if (content != other.content) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (policyId != other.policyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.UpdatePolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If provided, the new content for the policy. The text must be correctly formatted JSON that complies with the syntax for the policy's type. For more information, see [Service Control Policy Syntax](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html) in the *Organizations User Guide.*
         */
        public var content: kotlin.String? = null
        /**
         * If provided, the new description for the policy.
         */
        public var description: kotlin.String? = null
        /**
         * If provided, the new name for the policy.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter is a string of any of the characters in the ASCII character range.
         */
        public var name: kotlin.String? = null
        /**
         * The unique identifier (ID) of the policy that you want to update.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
         */
        public var policyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.UpdatePolicyRequest) : this() {
            this.content = x.content
            this.description = x.description
            this.name = x.name
            this.policyId = x.policyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.UpdatePolicyRequest = UpdatePolicyRequest(this)
    }
}
