// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model



public class TagResourceRequest private constructor(builder: Builder) {
    /**
     * The ID of the resource to add a tag to.
     *
     * You can specify any of the following taggable resources.
     * + Amazon Web Services account – specify the account ID number.
     * + Organizational unit – specify the OU ID that begins with `ou-` and looks similar to: `ou-<i>1a2b-34uvwxyz</i> `
     * + Root – specify the root ID that begins with `r-` and looks similar to: `r-<i>1a2b</i> `
     * + Policy – specify the policy ID that begins with `p-` andlooks similar to: `p-<i>12abcdefg3</i> `
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * A list of tags to add to the specified resource.
     *
     * For each tag in the list, you must specify both a tag key and a value. The value can be an empty string, but you can't set it to `null`.
     *
     * If any one of the tags is invalid or if you exceed the maximum allowed number of tags for a resource, then the entire request fails.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.TagResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TagResourceRequest(")
        append("resourceId=$resourceId,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceId?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TagResourceRequest

        if (resourceId != other.resourceId) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.TagResourceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the resource to add a tag to.
         *
         * You can specify any of the following taggable resources.
         * + Amazon Web Services account – specify the account ID number.
         * + Organizational unit – specify the OU ID that begins with `ou-` and looks similar to: `ou-<i>1a2b-34uvwxyz</i> `
         * + Root – specify the root ID that begins with `r-` and looks similar to: `r-<i>1a2b</i> `
         * + Policy – specify the policy ID that begins with `p-` andlooks similar to: `p-<i>12abcdefg3</i> `
         */
        public var resourceId: kotlin.String? = null
        /**
         * A list of tags to add to the specified resource.
         *
         * For each tag in the list, you must specify both a tag key and a value. The value can be an empty string, but you can't set it to `null`.
         *
         * If any one of the tags is invalid or if you exceed the maximum allowed number of tags for a resource, then the entire request fails.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.TagResourceRequest) : this() {
            this.resourceId = x.resourceId
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.TagResourceRequest = TagResourceRequest(this)
    }
}
