// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model



/**
 * Contains details about a root. A root is a top-level parent node in the hierarchy of an organization that can contain organizational units (OUs) and accounts. The root contains every Amazon Web Services account in the organization.
 */
public class Root private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the root.
     *
     * For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies) in the *Amazon Web Services Service Authorization Reference*.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The unique identifier (ID) for the root.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for a root ID string requires "r-" followed by from 4 to 32 lowercase letters or digits.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The friendly name of the root.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter is a string of any of the characters in the ASCII character range.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The types of policies that are currently enabled for the root and therefore can be attached to the root or to its OUs or accounts.
     *
     * Even if a policy type is shown as available in the organization, you can separately enable and disable them at the root level by using EnablePolicyType and DisablePolicyType. Use DescribeOrganization to see the availability of the policy types in that organization.
     */
    public val policyTypes: List<PolicyTypeSummary>? = builder.policyTypes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.Root = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Root(")
        append("arn=$arn,")
        append("id=$id,")
        append("name=$name,")
        append("policyTypes=$policyTypes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (policyTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Root

        if (arn != other.arn) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (policyTypes != other.policyTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.Root = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the root.
         *
         * For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies) in the *Amazon Web Services Service Authorization Reference*.
         */
        public var arn: kotlin.String? = null
        /**
         * The unique identifier (ID) for the root.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for a root ID string requires "r-" followed by from 4 to 32 lowercase letters or digits.
         */
        public var id: kotlin.String? = null
        /**
         * The friendly name of the root.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter is a string of any of the characters in the ASCII character range.
         */
        public var name: kotlin.String? = null
        /**
         * The types of policies that are currently enabled for the root and therefore can be attached to the root or to its OUs or accounts.
         *
         * Even if a policy type is shown as available in the organization, you can separately enable and disable them at the root level by using EnablePolicyType and DisablePolicyType. Use DescribeOrganization to see the availability of the policy types in that organization.
         */
        public var policyTypes: List<PolicyTypeSummary>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.Root) : this() {
            this.arn = x.arn
            this.id = x.id
            this.name = x.name
            this.policyTypes = x.policyTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.Root = Root(this)
    }
}
