// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model



public class MoveAccountRequest private constructor(builder: Builder) {
    /**
     * The unique identifier (ID) of the account that you want to move.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for an account ID string requires exactly 12 digits.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The unique identifier (ID) of the root or organizational unit that you want to move the account to.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for a parent ID string requires one of the following:
     * + **Root** - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
     * + **Organizational unit (OU)** - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
     */
    public val destinationParentId: kotlin.String? = builder.destinationParentId
    /**
     * The unique identifier (ID) of the root or organizational unit that you want to move the account from.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for a parent ID string requires one of the following:
     * + **Root** - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
     * + **Organizational unit (OU)** - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
     */
    public val sourceParentId: kotlin.String? = builder.sourceParentId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.MoveAccountRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MoveAccountRequest(")
        append("accountId=$accountId,")
        append("destinationParentId=$destinationParentId,")
        append("sourceParentId=$sourceParentId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (destinationParentId?.hashCode() ?: 0)
        result = 31 * result + (sourceParentId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MoveAccountRequest

        if (accountId != other.accountId) return false
        if (destinationParentId != other.destinationParentId) return false
        if (sourceParentId != other.sourceParentId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.MoveAccountRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier (ID) of the account that you want to move.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for an account ID string requires exactly 12 digits.
         */
        public var accountId: kotlin.String? = null
        /**
         * The unique identifier (ID) of the root or organizational unit that you want to move the account to.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for a parent ID string requires one of the following:
         * + **Root** - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
         * + **Organizational unit (OU)** - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
         */
        public var destinationParentId: kotlin.String? = null
        /**
         * The unique identifier (ID) of the root or organizational unit that you want to move the account from.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for a parent ID string requires one of the following:
         * + **Root** - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
         * + **Organizational unit (OU)** - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
         */
        public var sourceParentId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.MoveAccountRequest) : this() {
            this.accountId = x.accountId
            this.destinationParentId = x.destinationParentId
            this.sourceParentId = x.sourceParentId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.MoveAccountRequest = MoveAccountRequest(this)
    }
}
