// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model



/**
 * Contains additional data that is needed to process a handshake.
 */
public class HandshakeResource private constructor(builder: Builder) {
    /**
     * When needed, contains an additional array of `HandshakeResource` objects.
     */
    public val resources: List<HandshakeResource>? = builder.resources
    /**
     * The type of information being passed, specifying how the value is to be interpreted by the other party:
     * + `ACCOUNT` - Specifies an Amazon Web Services account ID number.
     * + `ORGANIZATION` - Specifies an organization ID number.
     * + `EMAIL` - Specifies the email address that is associated with the account that receives the handshake.
     * + `OWNER_EMAIL` - Specifies the email address associated with the management account. Included as information about an organization.
     * + `OWNER_NAME` - Specifies the name associated with the management account. Included as information about an organization.
     * + `NOTES` - Additional text provided by the handshake initiator and intended for the recipient to read.
     */
    public val type: aws.sdk.kotlin.services.organizations.model.HandshakeResourceType? = builder.type
    /**
     * The information that is passed to the other party in the handshake. The format of the value string must match the requirements of the specified type.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.HandshakeResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HandshakeResource(")
        append("resources=$resources,")
        append("type=$type,")
        append("value=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resources?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HandshakeResource

        if (resources != other.resources) return false
        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.HandshakeResource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * When needed, contains an additional array of `HandshakeResource` objects.
         */
        public var resources: List<HandshakeResource>? = null
        /**
         * The type of information being passed, specifying how the value is to be interpreted by the other party:
         * + `ACCOUNT` - Specifies an Amazon Web Services account ID number.
         * + `ORGANIZATION` - Specifies an organization ID number.
         * + `EMAIL` - Specifies the email address that is associated with the account that receives the handshake.
         * + `OWNER_EMAIL` - Specifies the email address associated with the management account. Included as information about an organization.
         * + `OWNER_NAME` - Specifies the name associated with the management account. Included as information about an organization.
         * + `NOTES` - Additional text provided by the handshake initiator and intended for the recipient to read.
         */
        public var type: aws.sdk.kotlin.services.organizations.model.HandshakeResourceType? = null
        /**
         * The information that is passed to the other party in the handshake. The format of the value string must match the requirements of the specified type.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.HandshakeResource) : this() {
            this.resources = x.resources
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.HandshakeResource = HandshakeResource(this)
    }
}
