// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model



public class CreateAccountRequest private constructor(builder: Builder) {
    /**
     * The friendly name of the member account.
     */
    public val accountName: kotlin.String? = builder.accountName
    /**
     * The email address of the owner to assign to the new member account. This email address must not already be associated with another Amazon Web Services account. You must use a valid email address to complete account creation.
     *
     * The rules for a valid email address:
     * + The address must be a minimum of 6 and a maximum of 64 characters long.
     * + All characters must be 7-bit ASCII characters.
     * + There must be one and only one @ symbol, which separates the local name from the domain name.
     * + The local name can't contain any of the following characters:whitespace, " ' ( ) < > &#91; &#93; : ; , \ | % &
     * + The local name can't begin with a dot (.)
     * + The domain name can consist of only the characters &#91;a-z&#93;,&#91;A-Z&#93;,&#91;0-9&#93;, hyphen (-), or dot (.)
     * + The domain name can't begin or end with a hyphen (-) or dot (.)
     * + The domain name must contain at least one dot
     *
     * You can't access the root user of the account or remove an account that was created with an invalid email address.
     */
    public val email: kotlin.String? = builder.email
    /**
     * If set to `ALLOW`, the new account enables IAM users to access account billing information *if* they have the required permissions. If set to `DENY`, only the root user of the new account can access account billing information. For more information, see [Activating Access to the Billing and Cost Management Console](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate) in the *Amazon Web Services Billing and Cost Management User Guide*.
     *
     * If you don't specify this parameter, the value defaults to `ALLOW`, and IAM users and roles with the required permissions can access billing information for the new account.
     */
    public val iamUserAccessToBilling: aws.sdk.kotlin.services.organizations.model.IamUserAccessToBilling? = builder.iamUserAccessToBilling
    /**
     * The name of an IAM role that Organizations automatically preconfigures in the new member account. This role trusts the management account, allowing users in the management account to assume the role, as permitted by the management account administrator. The role has administrator permissions in the new member account.
     *
     * If you don't specify this parameter, the role name defaults to `OrganizationAccountAccessRole`.
     *
     * For more information about how to use this role to access the member account, see the following links:
     * + [Accessing and Administering the Member Accounts in Your Organization](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role) in the *Organizations User Guide*
     * + Steps 2 and 3 in [Tutorial: Delegate Access Across Amazon Web Services accounts Using IAM Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html) in the *IAM User Guide*
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter. The pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-
     */
    public val roleName: kotlin.String? = builder.roleName
    /**
     * A list of tags that you want to attach to the newly created account. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to `null`. For more information about tagging, see [Tagging Organizations resources](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html) in the Organizations User Guide.
     *
     * If any one of the tags is invalid or if you exceed the maximum allowed number of tags for an account, then the entire request fails and the account is not created.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.CreateAccountRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAccountRequest(")
        append("accountName=*** Sensitive Data Redacted ***,")
        append("email=*** Sensitive Data Redacted ***,")
        append("iamUserAccessToBilling=$iamUserAccessToBilling,")
        append("roleName=$roleName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountName?.hashCode() ?: 0
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (iamUserAccessToBilling?.hashCode() ?: 0)
        result = 31 * result + (roleName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAccountRequest

        if (accountName != other.accountName) return false
        if (email != other.email) return false
        if (iamUserAccessToBilling != other.iamUserAccessToBilling) return false
        if (roleName != other.roleName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.CreateAccountRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The friendly name of the member account.
         */
        public var accountName: kotlin.String? = null
        /**
         * The email address of the owner to assign to the new member account. This email address must not already be associated with another Amazon Web Services account. You must use a valid email address to complete account creation.
         *
         * The rules for a valid email address:
         * + The address must be a minimum of 6 and a maximum of 64 characters long.
         * + All characters must be 7-bit ASCII characters.
         * + There must be one and only one @ symbol, which separates the local name from the domain name.
         * + The local name can't contain any of the following characters:whitespace, " ' ( ) < > &#91; &#93; : ; , \ | % &
         * + The local name can't begin with a dot (.)
         * + The domain name can consist of only the characters &#91;a-z&#93;,&#91;A-Z&#93;,&#91;0-9&#93;, hyphen (-), or dot (.)
         * + The domain name can't begin or end with a hyphen (-) or dot (.)
         * + The domain name must contain at least one dot
         *
         * You can't access the root user of the account or remove an account that was created with an invalid email address.
         */
        public var email: kotlin.String? = null
        /**
         * If set to `ALLOW`, the new account enables IAM users to access account billing information *if* they have the required permissions. If set to `DENY`, only the root user of the new account can access account billing information. For more information, see [Activating Access to the Billing and Cost Management Console](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate) in the *Amazon Web Services Billing and Cost Management User Guide*.
         *
         * If you don't specify this parameter, the value defaults to `ALLOW`, and IAM users and roles with the required permissions can access billing information for the new account.
         */
        public var iamUserAccessToBilling: aws.sdk.kotlin.services.organizations.model.IamUserAccessToBilling? = null
        /**
         * The name of an IAM role that Organizations automatically preconfigures in the new member account. This role trusts the management account, allowing users in the management account to assume the role, as permitted by the management account administrator. The role has administrator permissions in the new member account.
         *
         * If you don't specify this parameter, the role name defaults to `OrganizationAccountAccessRole`.
         *
         * For more information about how to use this role to access the member account, see the following links:
         * + [Accessing and Administering the Member Accounts in Your Organization](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role) in the *Organizations User Guide*
         * + Steps 2 and 3 in [Tutorial: Delegate Access Across Amazon Web Services accounts Using IAM Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html) in the *IAM User Guide*
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter. The pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-
         */
        public var roleName: kotlin.String? = null
        /**
         * A list of tags that you want to attach to the newly created account. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to `null`. For more information about tagging, see [Tagging Organizations resources](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html) in the Organizations User Guide.
         *
         * If any one of the tags is invalid or if you exceed the maximum allowed number of tags for an account, then the entire request fails and the account is not created.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.CreateAccountRequest) : this() {
            this.accountName = x.accountName
            this.email = x.email
            this.iamUserAccessToBilling = x.iamUserAccessToBilling
            this.roleName = x.roleName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.CreateAccountRequest = CreateAccountRequest(this)
    }
}
