// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an Amazon Web Services account that is a member of an organization.
 */
public class Account private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the account.
     *
     * For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies) in the *Amazon Web Services Service Authorization Reference*.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The email address associated with the Amazon Web Services account.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for this parameter is a string of characters that represents a standard internet email address.
     */
    public val email: kotlin.String? = builder.email
    /**
     * The unique identifier (ID) of the account.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for an account ID string requires exactly 12 digits.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The method by which the account joined the organization.
     */
    public val joinedMethod: aws.sdk.kotlin.services.organizations.model.AccountJoinedMethod? = builder.joinedMethod
    /**
     * The date the account became a part of the organization.
     */
    public val joinedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.joinedTimestamp
    /**
     * The friendly name of the account.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter is a string of any of the characters in the ASCII character range.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The status of the account in the organization.
     */
    public val status: aws.sdk.kotlin.services.organizations.model.AccountStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.Account = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Account(")
        append("arn=$arn,")
        append("email=*** Sensitive Data Redacted ***,")
        append("id=$id,")
        append("joinedMethod=$joinedMethod,")
        append("joinedTimestamp=$joinedTimestamp,")
        append("name=*** Sensitive Data Redacted ***,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (joinedMethod?.hashCode() ?: 0)
        result = 31 * result + (joinedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Account

        if (arn != other.arn) return false
        if (email != other.email) return false
        if (id != other.id) return false
        if (joinedMethod != other.joinedMethod) return false
        if (joinedTimestamp != other.joinedTimestamp) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.Account = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the account.
         *
         * For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies) in the *Amazon Web Services Service Authorization Reference*.
         */
        public var arn: kotlin.String? = null
        /**
         * The email address associated with the Amazon Web Services account.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for this parameter is a string of characters that represents a standard internet email address.
         */
        public var email: kotlin.String? = null
        /**
         * The unique identifier (ID) of the account.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for an account ID string requires exactly 12 digits.
         */
        public var id: kotlin.String? = null
        /**
         * The method by which the account joined the organization.
         */
        public var joinedMethod: aws.sdk.kotlin.services.organizations.model.AccountJoinedMethod? = null
        /**
         * The date the account became a part of the organization.
         */
        public var joinedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The friendly name of the account.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter is a string of any of the characters in the ASCII character range.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the account in the organization.
         */
        public var status: aws.sdk.kotlin.services.organizations.model.AccountStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.Account) : this() {
            this.arn = x.arn
            this.email = x.email
            this.id = x.id
            this.joinedMethod = x.joinedMethod
            this.joinedTimestamp = x.joinedTimestamp
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.Account = Account(this)
    }
}
