// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.organizations.model.Child
import aws.sdk.kotlin.services.organizations.model.ListChildrenResponse
import aws.sdk.kotlin.services.organizations.model.OrganizationsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListChildrenOperationDeserializer: HttpDeserialize<ListChildrenResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListChildrenResponse {
        if (!response.status.isSuccess()) {
            throwListChildrenError(context, response)
        }
        val builder = ListChildrenResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListChildrenOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListChildrenError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OrganizationsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AWSOrganizationsNotInUseException" -> AwsOrganizationsNotInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "ParentNotFoundException" -> ParentNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OrganizationsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListChildrenOperationBody(builder: ListChildrenResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHILDREN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Children"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHILDREN_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHILDREN_DESCRIPTOR.index -> builder.children =
                    deserializer.deserializeList(CHILDREN_DESCRIPTOR) {
                        val col0 = mutableListOf<Child>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeChildDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
