// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.paginators

import aws.sdk.kotlin.services.organizations.OrganizationsClient
import aws.sdk.kotlin.services.organizations.model.DelegatedAdministrator
import aws.sdk.kotlin.services.organizations.model.DelegatedService
import aws.sdk.kotlin.services.organizations.model.ListAccountsForParentRequest
import aws.sdk.kotlin.services.organizations.model.ListAccountsForParentResponse
import aws.sdk.kotlin.services.organizations.model.ListAccountsRequest
import aws.sdk.kotlin.services.organizations.model.ListAccountsResponse
import aws.sdk.kotlin.services.organizations.model.ListAwsServiceAccessForOrganizationRequest
import aws.sdk.kotlin.services.organizations.model.ListAwsServiceAccessForOrganizationResponse
import aws.sdk.kotlin.services.organizations.model.ListChildrenRequest
import aws.sdk.kotlin.services.organizations.model.ListChildrenResponse
import aws.sdk.kotlin.services.organizations.model.ListCreateAccountStatusRequest
import aws.sdk.kotlin.services.organizations.model.ListCreateAccountStatusResponse
import aws.sdk.kotlin.services.organizations.model.ListDelegatedAdministratorsRequest
import aws.sdk.kotlin.services.organizations.model.ListDelegatedAdministratorsResponse
import aws.sdk.kotlin.services.organizations.model.ListDelegatedServicesForAccountRequest
import aws.sdk.kotlin.services.organizations.model.ListDelegatedServicesForAccountResponse
import aws.sdk.kotlin.services.organizations.model.ListHandshakesForAccountRequest
import aws.sdk.kotlin.services.organizations.model.ListHandshakesForAccountResponse
import aws.sdk.kotlin.services.organizations.model.ListHandshakesForOrganizationRequest
import aws.sdk.kotlin.services.organizations.model.ListHandshakesForOrganizationResponse
import aws.sdk.kotlin.services.organizations.model.ListOrganizationalUnitsForParentRequest
import aws.sdk.kotlin.services.organizations.model.ListOrganizationalUnitsForParentResponse
import aws.sdk.kotlin.services.organizations.model.ListParentsRequest
import aws.sdk.kotlin.services.organizations.model.ListParentsResponse
import aws.sdk.kotlin.services.organizations.model.ListPoliciesForTargetRequest
import aws.sdk.kotlin.services.organizations.model.ListPoliciesForTargetResponse
import aws.sdk.kotlin.services.organizations.model.ListPoliciesRequest
import aws.sdk.kotlin.services.organizations.model.ListPoliciesResponse
import aws.sdk.kotlin.services.organizations.model.ListRootsRequest
import aws.sdk.kotlin.services.organizations.model.ListRootsResponse
import aws.sdk.kotlin.services.organizations.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.organizations.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.organizations.model.ListTargetsForPolicyRequest
import aws.sdk.kotlin.services.organizations.model.ListTargetsForPolicyResponse
import aws.sdk.kotlin.services.organizations.model.Tag
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccountsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountsResponse]
 */
fun OrganizationsClient.listAccountsPaginated(initialRequest: ListAccountsRequest): Flow<ListAccountsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccountsPaginated.listAccounts(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountsResponse]
 */
fun OrganizationsClient.listAccountsPaginated(block: ListAccountsRequest.Builder.() -> Unit): Flow<ListAccountsResponse> =
    listAccountsPaginated(ListAccountsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAccountsForParentResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccountsForParentRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountsForParentResponse]
 */
fun OrganizationsClient.listAccountsForParentPaginated(initialRequest: ListAccountsForParentRequest): Flow<ListAccountsForParentResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccountsForParentPaginated.listAccountsForParent(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAccountsForParentResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountsForParentResponse]
 */
fun OrganizationsClient.listAccountsForParentPaginated(block: ListAccountsForParentRequest.Builder.() -> Unit): Flow<ListAccountsForParentResponse> =
    listAccountsForParentPaginated(ListAccountsForParentRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAwsServiceAccessForOrganizationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAwsServiceAccessForOrganizationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAwsServiceAccessForOrganizationResponse]
 */
fun OrganizationsClient.listAwsServiceAccessForOrganizationPaginated(initialRequest: ListAwsServiceAccessForOrganizationRequest): Flow<ListAwsServiceAccessForOrganizationResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAwsServiceAccessForOrganizationPaginated.listAwsServiceAccessForOrganization(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAwsServiceAccessForOrganizationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAwsServiceAccessForOrganizationResponse]
 */
fun OrganizationsClient.listAwsServiceAccessForOrganizationPaginated(block: ListAwsServiceAccessForOrganizationRequest.Builder.() -> Unit): Flow<ListAwsServiceAccessForOrganizationResponse> =
    listAwsServiceAccessForOrganizationPaginated(ListAwsServiceAccessForOrganizationRequest.Builder().apply(block).build())

/**
 * Paginate over [ListChildrenResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChildrenRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChildrenResponse]
 */
fun OrganizationsClient.listChildrenPaginated(initialRequest: ListChildrenRequest): Flow<ListChildrenResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChildrenPaginated.listChildren(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListChildrenResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChildrenResponse]
 */
fun OrganizationsClient.listChildrenPaginated(block: ListChildrenRequest.Builder.() -> Unit): Flow<ListChildrenResponse> =
    listChildrenPaginated(ListChildrenRequest.Builder().apply(block).build())

/**
 * Paginate over [ListCreateAccountStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCreateAccountStatusRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCreateAccountStatusResponse]
 */
fun OrganizationsClient.listCreateAccountStatusPaginated(initialRequest: ListCreateAccountStatusRequest): Flow<ListCreateAccountStatusResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCreateAccountStatusPaginated.listCreateAccountStatus(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCreateAccountStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCreateAccountStatusResponse]
 */
fun OrganizationsClient.listCreateAccountStatusPaginated(block: ListCreateAccountStatusRequest.Builder.() -> Unit): Flow<ListCreateAccountStatusResponse> =
    listCreateAccountStatusPaginated(ListCreateAccountStatusRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDelegatedAdministratorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDelegatedAdministratorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDelegatedAdministratorsResponse]
 */
fun OrganizationsClient.listDelegatedAdministratorsPaginated(initialRequest: ListDelegatedAdministratorsRequest): Flow<ListDelegatedAdministratorsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDelegatedAdministratorsPaginated.listDelegatedAdministrators(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDelegatedAdministratorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDelegatedAdministratorsResponse]
 */
fun OrganizationsClient.listDelegatedAdministratorsPaginated(block: ListDelegatedAdministratorsRequest.Builder.() -> Unit): Flow<ListDelegatedAdministratorsResponse> =
    listDelegatedAdministratorsPaginated(ListDelegatedAdministratorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDelegatedAdministratorsPaginated]
 * to access the nested member [DelegatedAdministrator]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DelegatedAdministrator]
 */
@JvmName("listDelegatedAdministratorsResponseDelegatedAdministrator")
fun Flow<ListDelegatedAdministratorsResponse>.delegatedAdministrators(): Flow<DelegatedAdministrator> =
    transform() { response ->
        response.delegatedAdministrators?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDelegatedServicesForAccountResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDelegatedServicesForAccountRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDelegatedServicesForAccountResponse]
 */
fun OrganizationsClient.listDelegatedServicesForAccountPaginated(initialRequest: ListDelegatedServicesForAccountRequest): Flow<ListDelegatedServicesForAccountResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDelegatedServicesForAccountPaginated.listDelegatedServicesForAccount(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDelegatedServicesForAccountResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDelegatedServicesForAccountResponse]
 */
fun OrganizationsClient.listDelegatedServicesForAccountPaginated(block: ListDelegatedServicesForAccountRequest.Builder.() -> Unit): Flow<ListDelegatedServicesForAccountResponse> =
    listDelegatedServicesForAccountPaginated(ListDelegatedServicesForAccountRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDelegatedServicesForAccountPaginated]
 * to access the nested member [DelegatedService]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DelegatedService]
 */
@JvmName("listDelegatedServicesForAccountResponseDelegatedService")
fun Flow<ListDelegatedServicesForAccountResponse>.delegatedServices(): Flow<DelegatedService> =
    transform() { response ->
        response.delegatedServices?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListHandshakesForAccountResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListHandshakesForAccountRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHandshakesForAccountResponse]
 */
fun OrganizationsClient.listHandshakesForAccountPaginated(initialRequest: ListHandshakesForAccountRequest): Flow<ListHandshakesForAccountResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listHandshakesForAccountPaginated.listHandshakesForAccount(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListHandshakesForAccountResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHandshakesForAccountResponse]
 */
fun OrganizationsClient.listHandshakesForAccountPaginated(block: ListHandshakesForAccountRequest.Builder.() -> Unit): Flow<ListHandshakesForAccountResponse> =
    listHandshakesForAccountPaginated(ListHandshakesForAccountRequest.Builder().apply(block).build())

/**
 * Paginate over [ListHandshakesForOrganizationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListHandshakesForOrganizationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHandshakesForOrganizationResponse]
 */
fun OrganizationsClient.listHandshakesForOrganizationPaginated(initialRequest: ListHandshakesForOrganizationRequest): Flow<ListHandshakesForOrganizationResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listHandshakesForOrganizationPaginated.listHandshakesForOrganization(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListHandshakesForOrganizationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHandshakesForOrganizationResponse]
 */
fun OrganizationsClient.listHandshakesForOrganizationPaginated(block: ListHandshakesForOrganizationRequest.Builder.() -> Unit): Flow<ListHandshakesForOrganizationResponse> =
    listHandshakesForOrganizationPaginated(ListHandshakesForOrganizationRequest.Builder().apply(block).build())

/**
 * Paginate over [ListOrganizationalUnitsForParentResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOrganizationalUnitsForParentRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOrganizationalUnitsForParentResponse]
 */
fun OrganizationsClient.listOrganizationalUnitsForParentPaginated(initialRequest: ListOrganizationalUnitsForParentRequest): Flow<ListOrganizationalUnitsForParentResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listOrganizationalUnitsForParentPaginated.listOrganizationalUnitsForParent(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListOrganizationalUnitsForParentResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOrganizationalUnitsForParentResponse]
 */
fun OrganizationsClient.listOrganizationalUnitsForParentPaginated(block: ListOrganizationalUnitsForParentRequest.Builder.() -> Unit): Flow<ListOrganizationalUnitsForParentResponse> =
    listOrganizationalUnitsForParentPaginated(ListOrganizationalUnitsForParentRequest.Builder().apply(block).build())

/**
 * Paginate over [ListParentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListParentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListParentsResponse]
 */
fun OrganizationsClient.listParentsPaginated(initialRequest: ListParentsRequest): Flow<ListParentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listParentsPaginated.listParents(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListParentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListParentsResponse]
 */
fun OrganizationsClient.listParentsPaginated(block: ListParentsRequest.Builder.() -> Unit): Flow<ListParentsResponse> =
    listParentsPaginated(ListParentsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPoliciesResponse]
 */
fun OrganizationsClient.listPoliciesPaginated(initialRequest: ListPoliciesRequest): Flow<ListPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPoliciesPaginated.listPolicies(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPoliciesResponse]
 */
fun OrganizationsClient.listPoliciesPaginated(block: ListPoliciesRequest.Builder.() -> Unit): Flow<ListPoliciesResponse> =
    listPoliciesPaginated(ListPoliciesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPoliciesForTargetResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPoliciesForTargetRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPoliciesForTargetResponse]
 */
fun OrganizationsClient.listPoliciesForTargetPaginated(initialRequest: ListPoliciesForTargetRequest): Flow<ListPoliciesForTargetResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPoliciesForTargetPaginated.listPoliciesForTarget(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPoliciesForTargetResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPoliciesForTargetResponse]
 */
fun OrganizationsClient.listPoliciesForTargetPaginated(block: ListPoliciesForTargetRequest.Builder.() -> Unit): Flow<ListPoliciesForTargetResponse> =
    listPoliciesForTargetPaginated(ListPoliciesForTargetRequest.Builder().apply(block).build())

/**
 * Paginate over [ListRootsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRootsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRootsResponse]
 */
fun OrganizationsClient.listRootsPaginated(initialRequest: ListRootsRequest): Flow<ListRootsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRootsPaginated.listRoots(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRootsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRootsResponse]
 */
fun OrganizationsClient.listRootsPaginated(block: ListRootsRequest.Builder.() -> Unit): Flow<ListRootsResponse> =
    listRootsPaginated(ListRootsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
fun OrganizationsClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
fun OrganizationsClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsForResourcePaginated]
 * to access the nested member [Tag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tag]
 */
@JvmName("listTagsForResourceResponseTag")
fun Flow<ListTagsForResourceResponse>.tags(): Flow<Tag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTargetsForPolicyResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTargetsForPolicyRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTargetsForPolicyResponse]
 */
fun OrganizationsClient.listTargetsForPolicyPaginated(initialRequest: ListTargetsForPolicyRequest): Flow<ListTargetsForPolicyResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTargetsForPolicyPaginated.listTargetsForPolicy(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTargetsForPolicyResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTargetsForPolicyResponse]
 */
fun OrganizationsClient.listTargetsForPolicyPaginated(block: ListTargetsForPolicyRequest.Builder.() -> Unit): Flow<ListTargetsForPolicyResponse> =
    listTargetsForPolicyPaginated(ListTargetsForPolicyRequest.Builder().apply(block).build())
