// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model



class UpdatePolicyRequest private constructor(builder: Builder) {
    /**
     * If provided, the new content for the policy. The text must be correctly formatted JSON that complies with the syntax for the policy's type. For more information, see [Service Control Policy Syntax](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html) in the *Organizations User Guide.*
     */
    val content: kotlin.String? = builder.content
    /**
     * If provided, the new description for the policy.
     */
    val description: kotlin.String? = builder.description
    /**
     * If provided, the new name for the policy.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter is a string of any of the characters in the ASCII character range.
     */
    val name: kotlin.String? = builder.name
    /**
     * The unique identifier (ID) of the policy that you want to update.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
     */
    val policyId: kotlin.String? = builder.policyId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.UpdatePolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdatePolicyRequest(")
        append("content=$content,")
        append("description=$description,")
        append("name=$name,")
        append("policyId=$policyId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (policyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdatePolicyRequest

        if (content != other.content) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (policyId != other.policyId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.UpdatePolicyRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * If provided, the new content for the policy. The text must be correctly formatted JSON that complies with the syntax for the policy's type. For more information, see [Service Control Policy Syntax](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html) in the *Organizations User Guide.*
         */
        var content: kotlin.String? = null
        /**
         * If provided, the new description for the policy.
         */
        var description: kotlin.String? = null
        /**
         * If provided, the new name for the policy.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter is a string of any of the characters in the ASCII character range.
         */
        var name: kotlin.String? = null
        /**
         * The unique identifier (ID) of the policy that you want to update.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
         */
        var policyId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.UpdatePolicyRequest) : this() {
            this.content = x.content
            this.description = x.description
            this.name = x.name
            this.policyId = x.policyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.UpdatePolicyRequest = UpdatePolicyRequest(this)
    }
}
