// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model



/**
 * Contains information about a root, OU, or account that a policy is attached to.
 */
class PolicyTargetSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the policy target.
     *
     * For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies) in the *Amazon Web Services Service Authorization Reference*.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The friendly name of the policy target.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter is a string of any of the characters in the ASCII character range.
     */
    val name: kotlin.String? = builder.name
    /**
     * The unique identifier (ID) of the policy target.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for a target ID string requires one of the following:
     * + **Root** - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
     * + **Account** - A string that consists of exactly 12 digits.
     * + **Organizational unit (OU)** - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
     */
    val targetId: kotlin.String? = builder.targetId
    /**
     * The type of the policy target.
     */
    val type: aws.sdk.kotlin.services.organizations.model.TargetType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.PolicyTargetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyTargetSummary(")
        append("arn=$arn,")
        append("name=$name,")
        append("targetId=$targetId,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (targetId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicyTargetSummary

        if (arn != other.arn) return false
        if (name != other.name) return false
        if (targetId != other.targetId) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.PolicyTargetSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the policy target.
         *
         * For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies) in the *Amazon Web Services Service Authorization Reference*.
         */
        var arn: kotlin.String? = null
        /**
         * The friendly name of the policy target.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter is a string of any of the characters in the ASCII character range.
         */
        var name: kotlin.String? = null
        /**
         * The unique identifier (ID) of the policy target.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for a target ID string requires one of the following:
         * + **Root** - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
         * + **Account** - A string that consists of exactly 12 digits.
         * + **Organizational unit (OU)** - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
         */
        var targetId: kotlin.String? = null
        /**
         * The type of the policy target.
         */
        var type: aws.sdk.kotlin.services.organizations.model.TargetType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.PolicyTargetSummary) : this() {
            this.arn = x.arn
            this.name = x.name
            this.targetId = x.targetId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.PolicyTargetSummary = PolicyTargetSummary(this)
    }
}
