// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model



/**
 * Contains details about an organizational unit (OU). An OU is a container of Amazon Web Services accounts within a root of an organization. Policies that are attached to an OU apply to all accounts contained in that OU and in any child OUs.
 */
class OrganizationalUnit private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of this OU.
     *
     * For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies) in the *Amazon Web Services Service Authorization Reference*.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The unique identifier (ID) associated with this OU.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
     */
    val id: kotlin.String? = builder.id
    /**
     * The friendly name of this OU.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter is a string of any of the characters in the ASCII character range.
     */
    val name: kotlin.String? = builder.name

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.OrganizationalUnit = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OrganizationalUnit(")
        append("arn=$arn,")
        append("id=$id,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OrganizationalUnit

        if (arn != other.arn) return false
        if (id != other.id) return false
        if (name != other.name) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.OrganizationalUnit = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of this OU.
         *
         * For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies) in the *Amazon Web Services Service Authorization Reference*.
         */
        var arn: kotlin.String? = null
        /**
         * The unique identifier (ID) associated with this OU.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
         */
        var id: kotlin.String? = null
        /**
         * The friendly name of this OU.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter is a string of any of the characters in the ASCII character range.
         */
        var name: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.OrganizationalUnit) : this() {
            this.arn = x.arn
            this.id = x.id
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.OrganizationalUnit = OrganizationalUnit(this)
    }
}
