// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model



/**
 * Contains details about an organization. An organization is a collection of accounts that are centrally managed together using consolidated billing, organized hierarchically with organizational units (OUs), and controlled with policies .
 */
class Organization private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of an organization.
     *
     * For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies) in the *Amazon Web Services Service Authorization Reference*.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * Do not use. This field is deprecated and doesn't provide complete information about the policies in your organization.
     *
     * To determine the policies that are enabled and available for use in your organization, use the ListRoots operation instead.
     */
    val availablePolicyTypes: List<PolicyTypeSummary>? = builder.availablePolicyTypes
    /**
     * Specifies the functionality that currently is available to the organization. If set to "ALL", then all features are enabled and policies can be applied to accounts in the organization. If set to "CONSOLIDATED_BILLING", then only consolidated billing functionality is available. For more information, see [Enabling All Features in Your Organization](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html) in the *Organizations User Guide*.
     */
    val featureSet: aws.sdk.kotlin.services.organizations.model.OrganizationFeatureSet? = builder.featureSet
    /**
     * The unique identifier (ID) of an organization.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for an organization ID string requires "o-" followed by from 10 to 32 lowercase letters or digits.
     */
    val id: kotlin.String? = builder.id
    /**
     * The Amazon Resource Name (ARN) of the account that is designated as the management account for the organization.
     *
     * For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies) in the *Amazon Web Services Service Authorization Reference*.
     */
    val masterAccountArn: kotlin.String? = builder.masterAccountArn
    /**
     * The email address that is associated with the Amazon Web Services account that is designated as the management account for the organization.
     */
    val masterAccountEmail: kotlin.String? = builder.masterAccountEmail
    /**
     * The unique identifier (ID) of the management account of an organization.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for an account ID string requires exactly 12 digits.
     */
    val masterAccountId: kotlin.String? = builder.masterAccountId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.Organization = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Organization(")
        append("arn=$arn,")
        append("availablePolicyTypes=$availablePolicyTypes,")
        append("featureSet=$featureSet,")
        append("id=$id,")
        append("masterAccountArn=$masterAccountArn,")
        append("masterAccountEmail=*** Sensitive Data Redacted ***,")
        append("masterAccountId=$masterAccountId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (availablePolicyTypes?.hashCode() ?: 0)
        result = 31 * result + (featureSet?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (masterAccountArn?.hashCode() ?: 0)
        result = 31 * result + (masterAccountEmail?.hashCode() ?: 0)
        result = 31 * result + (masterAccountId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Organization

        if (arn != other.arn) return false
        if (availablePolicyTypes != other.availablePolicyTypes) return false
        if (featureSet != other.featureSet) return false
        if (id != other.id) return false
        if (masterAccountArn != other.masterAccountArn) return false
        if (masterAccountEmail != other.masterAccountEmail) return false
        if (masterAccountId != other.masterAccountId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.Organization = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of an organization.
         *
         * For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies) in the *Amazon Web Services Service Authorization Reference*.
         */
        var arn: kotlin.String? = null
        /**
         * Do not use. This field is deprecated and doesn't provide complete information about the policies in your organization.
         *
         * To determine the policies that are enabled and available for use in your organization, use the ListRoots operation instead.
         */
        var availablePolicyTypes: List<PolicyTypeSummary>? = null
        /**
         * Specifies the functionality that currently is available to the organization. If set to "ALL", then all features are enabled and policies can be applied to accounts in the organization. If set to "CONSOLIDATED_BILLING", then only consolidated billing functionality is available. For more information, see [Enabling All Features in Your Organization](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html) in the *Organizations User Guide*.
         */
        var featureSet: aws.sdk.kotlin.services.organizations.model.OrganizationFeatureSet? = null
        /**
         * The unique identifier (ID) of an organization.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for an organization ID string requires "o-" followed by from 10 to 32 lowercase letters or digits.
         */
        var id: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the account that is designated as the management account for the organization.
         *
         * For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies) in the *Amazon Web Services Service Authorization Reference*.
         */
        var masterAccountArn: kotlin.String? = null
        /**
         * The email address that is associated with the Amazon Web Services account that is designated as the management account for the organization.
         */
        var masterAccountEmail: kotlin.String? = null
        /**
         * The unique identifier (ID) of the management account of an organization.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for an account ID string requires exactly 12 digits.
         */
        var masterAccountId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.Organization) : this() {
            this.arn = x.arn
            this.availablePolicyTypes = x.availablePolicyTypes
            this.featureSet = x.featureSet
            this.id = x.id
            this.masterAccountArn = x.masterAccountArn
            this.masterAccountEmail = x.masterAccountEmail
            this.masterAccountId = x.masterAccountId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.Organization = Organization(this)
    }
}
