// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model



class ListPoliciesForTargetRequest private constructor(builder: Builder) {
    /**
     * The type of policy that you want to include in the returned list. You must specify one of the following values:
     * + [AISERVICES_OPT_OUT_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
     * + [BACKUP_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
     * + [SERVICE_CONTROL_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html)
     * + [TAG_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
     */
    val filter: aws.sdk.kotlin.services.organizations.model.PolicyType? = builder.filter
    /**
     * The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the `NextToken` response element is present and has a value (is not null). Include that value as the `NextToken` request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check `NextToken` after every operation to ensure that you receive all of the results.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The parameter for receiving additional results if you receive a `NextToken` response in a previous request. A `NextToken` response indicates that more output is available. Set this parameter to the value of the previous call's `NextToken` response to indicate where the output should continue from.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The unique identifier (ID) of the root, organizational unit, or account whose policies you want to list.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for a target ID string requires one of the following:
     * + **Root** - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
     * + **Account** - A string that consists of exactly 12 digits.
     * + **Organizational unit (OU)** - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
     */
    val targetId: kotlin.String? = builder.targetId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.ListPoliciesForTargetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPoliciesForTargetRequest(")
        append("filter=$filter,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("targetId=$targetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (targetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPoliciesForTargetRequest

        if (filter != other.filter) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (targetId != other.targetId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.ListPoliciesForTargetRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type of policy that you want to include in the returned list. You must specify one of the following values:
         * + [AISERVICES_OPT_OUT_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
         * + [BACKUP_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
         * + [SERVICE_CONTROL_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html)
         * + [TAG_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
         */
        var filter: aws.sdk.kotlin.services.organizations.model.PolicyType? = null
        /**
         * The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the `NextToken` response element is present and has a value (is not null). Include that value as the `NextToken` request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check `NextToken` after every operation to ensure that you receive all of the results.
         */
        var maxResults: kotlin.Int? = null
        /**
         * The parameter for receiving additional results if you receive a `NextToken` response in a previous request. A `NextToken` response indicates that more output is available. Set this parameter to the value of the previous call's `NextToken` response to indicate where the output should continue from.
         */
        var nextToken: kotlin.String? = null
        /**
         * The unique identifier (ID) of the root, organizational unit, or account whose policies you want to list.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for a target ID string requires one of the following:
         * + **Root** - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.
         * + **Account** - A string that consists of exactly 12 digits.
         * + **Organizational unit (OU)** - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
         */
        var targetId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.ListPoliciesForTargetRequest) : this() {
            this.filter = x.filter
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.targetId = x.targetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.ListPoliciesForTargetRequest = ListPoliciesForTargetRequest(this)
    }
}
