// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model



class InviteAccountToOrganizationRequest private constructor(builder: Builder) {
    /**
     * Additional information that you want to include in the generated email to the recipient account owner.
     */
    val notes: kotlin.String? = builder.notes
    /**
     * A list of tags that you want to attach to the account when it becomes a member of the organization. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to `null`. For more information about tagging, see [Tagging Organizations resources](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html) in the Organizations User Guide.
     *
     * Any tags in the request are checked for compliance with any applicable tag policies when the request is made. The request is rejected if the tags in the request don't match the requirements of the policy at that time. Tag policy compliance is ***not*** checked again when the invitation is accepted and the tags are actually attached to the account. That means that if the tag policy changes between the invitation and the acceptance, then that tags could potentially be non-compliant.
     *
     * If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the entire request fails and invitations are not sent.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The identifier (ID) of the Amazon Web Services account that you want to invite to join your organization. This is a JSON object that contains the following elements:
     *
     * `{ "Type": "ACCOUNT", "Id": "<<i> <b>account id number</b> </i>>" }`
     *
     * If you use the CLI, you can submit this as a single string, similar to the following example:
     *
     * `--target Id=123456789012,Type=ACCOUNT`
     *
     * If you specify `"Type": "ACCOUNT"`, you must provide the Amazon Web Services account ID number as the `Id`. If you specify `"Type": "EMAIL"`, you must specify the email address that is associated with the account.
     *
     * `--target Id=diego@example.com,Type=EMAIL`
     */
    val target: aws.sdk.kotlin.services.organizations.model.HandshakeParty? = builder.target

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.InviteAccountToOrganizationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InviteAccountToOrganizationRequest(")
        append("notes=*** Sensitive Data Redacted ***,")
        append("tags=$tags,")
        append("target=$target)")
    }

    override fun hashCode(): kotlin.Int {
        var result = notes?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InviteAccountToOrganizationRequest

        if (notes != other.notes) return false
        if (tags != other.tags) return false
        if (target != other.target) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.InviteAccountToOrganizationRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Additional information that you want to include in the generated email to the recipient account owner.
         */
        var notes: kotlin.String? = null
        /**
         * A list of tags that you want to attach to the account when it becomes a member of the organization. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to `null`. For more information about tagging, see [Tagging Organizations resources](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html) in the Organizations User Guide.
         *
         * Any tags in the request are checked for compliance with any applicable tag policies when the request is made. The request is rejected if the tags in the request don't match the requirements of the policy at that time. Tag policy compliance is ***not*** checked again when the invitation is accepted and the tags are actually attached to the account. That means that if the tag policy changes between the invitation and the acceptance, then that tags could potentially be non-compliant.
         *
         * If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the entire request fails and invitations are not sent.
         */
        var tags: List<Tag>? = null
        /**
         * The identifier (ID) of the Amazon Web Services account that you want to invite to join your organization. This is a JSON object that contains the following elements:
         *
         * `{ "Type": "ACCOUNT", "Id": "<<i> <b>account id number</b> </i>>" }`
         *
         * If you use the CLI, you can submit this as a single string, similar to the following example:
         *
         * `--target Id=123456789012,Type=ACCOUNT`
         *
         * If you specify `"Type": "ACCOUNT"`, you must provide the Amazon Web Services account ID number as the `Id`. If you specify `"Type": "EMAIL"`, you must specify the email address that is associated with the account.
         *
         * `--target Id=diego@example.com,Type=EMAIL`
         */
        var target: aws.sdk.kotlin.services.organizations.model.HandshakeParty? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.InviteAccountToOrganizationRequest) : this() {
            this.notes = x.notes
            this.tags = x.tags
            this.target = x.target
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.InviteAccountToOrganizationRequest = InviteAccountToOrganizationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.organizations.model.HandshakeParty] inside the given [block]
         */
        fun target(block: aws.sdk.kotlin.services.organizations.model.HandshakeParty.Builder.() -> kotlin.Unit) {
            this.target = aws.sdk.kotlin.services.organizations.model.HandshakeParty.invoke(block)
        }
    }
}
