// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:
 *
 * Some of the reasons in the following list might not be applicable to this specific API or operation.
 *
 * + DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.
 * + IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.
 * + INPUT_REQUIRED: You must include a value for all required parameters.
 * + INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.
 * + INVALID_ENUM: You specified an invalid value.
 * + INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
 * + INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.
 * + INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.
 * + INVALID_PAGINATION_TOKEN: Get the value for the `NextToken` parameter from the response to a previous call of the operation.
 * + INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.
 * + INVALID_PATTERN: You provided a value that doesn't match the required pattern.
 * + INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.
 * + INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix `AWSServiceRoleFor`.
 * + INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.
 * + INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
 * + INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.
 * + MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.
 * + MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.
 * + MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.
 * + MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.
 * + MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.
 * + MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.
 * + TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.
 * + UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.
 */
class InvalidInputException private constructor(builder: Builder) : OrganizationsException() {

    override val message: kotlin.String? = builder.message
    val reason: aws.sdk.kotlin.services.organizations.model.InvalidInputExceptionReason? = builder.reason

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.InvalidInputException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvalidInputException(")
        append("message=$message,")
        append("reason=$reason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (reason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvalidInputException

        if (message != other.message) return false
        if (reason != other.reason) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.InvalidInputException = Builder(this).apply(block).build()

    class Builder {
        var message: kotlin.String? = null
        var reason: aws.sdk.kotlin.services.organizations.model.InvalidInputExceptionReason? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.InvalidInputException) : this() {
            this.message = x.message
            this.reason = x.reason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.InvalidInputException = InvalidInputException(this)
    }
}
