// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model



/**
 * Specifies the criteria that are used to select the handshakes for the operation.
 */
class HandshakeFilter private constructor(builder: Builder) {
    /**
     * Specifies the type of handshake action.
     *
     * If you specify `ActionType`, you cannot also specify `ParentHandshakeId`.
     */
    val actionType: aws.sdk.kotlin.services.organizations.model.ActionType? = builder.actionType
    /**
     * Specifies the parent handshake. Only used for handshake types that are a child of another type.
     *
     * If you specify `ParentHandshakeId`, you cannot also specify `ActionType`.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.
     */
    val parentHandshakeId: kotlin.String? = builder.parentHandshakeId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.HandshakeFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HandshakeFilter(")
        append("actionType=$actionType,")
        append("parentHandshakeId=$parentHandshakeId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionType?.hashCode() ?: 0
        result = 31 * result + (parentHandshakeId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HandshakeFilter

        if (actionType != other.actionType) return false
        if (parentHandshakeId != other.parentHandshakeId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.HandshakeFilter = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the type of handshake action.
         *
         * If you specify `ActionType`, you cannot also specify `ParentHandshakeId`.
         */
        var actionType: aws.sdk.kotlin.services.organizations.model.ActionType? = null
        /**
         * Specifies the parent handshake. Only used for handshake types that are a child of another type.
         *
         * If you specify `ParentHandshakeId`, you cannot also specify `ActionType`.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.
         */
        var parentHandshakeId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.HandshakeFilter) : this() {
            this.actionType = x.actionType
            this.parentHandshakeId = x.parentHandshakeId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.HandshakeFilter = HandshakeFilter(this)
    }
}
