// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * The requested operation would violate the constraint identified in the reason code.
 *
 * Some of the reasons in the following list might not be applicable to this specific API or operation:
 *
 * + ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. Note that deleted and closed accounts still count toward your limit.If you get this exception immediately after creating the organization, wait one hour and try again. If after an hour it continues to fail with this error, contact [Amazon Web Services Support](https://docs.aws.amazon.com/support/home#/).
 * + ALREADY_IN_AN_ORGANIZATION: The handshake request is invalid because the invited account is already a member of an organization.
 * + HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.
 * + INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES: You can't issue new invitations to join an organization while it's in the process of enabling all features. You can resume inviting accounts after you finalize the process when all accounts have agreed to the change.
 * + ORGANIZATION_ALREADY_HAS_ALL_FEATURES: The handshake request is invalid because the organization has already enabled all features.
 * + ORGANIZATION_IS_ALREADY_PENDING_ALL_FEATURES_MIGRATION: The handshake request is invalid because the organization has already started the process to enable all features.
 * + ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD: The request failed because the account is from a different marketplace than the accounts in the organization. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be from the same marketplace.
 * + ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED: You attempted to change the membership of an account too quickly after its previous change.
 * + PAYMENT_INSTRUMENT_REQUIRED: You can't complete the operation with an account that doesn't have a payment instrument, such as a credit card, associated with it.
 */
class HandshakeConstraintViolationException private constructor(builder: Builder) : OrganizationsException() {

    override val message: kotlin.String? = builder.message
    val reason: aws.sdk.kotlin.services.organizations.model.HandshakeConstraintViolationExceptionReason? = builder.reason

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.HandshakeConstraintViolationException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HandshakeConstraintViolationException(")
        append("message=$message,")
        append("reason=$reason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (reason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HandshakeConstraintViolationException

        if (message != other.message) return false
        if (reason != other.reason) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.HandshakeConstraintViolationException = Builder(this).apply(block).build()

    class Builder {
        var message: kotlin.String? = null
        var reason: aws.sdk.kotlin.services.organizations.model.HandshakeConstraintViolationExceptionReason? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.HandshakeConstraintViolationException) : this() {
            this.message = x.message
            this.reason = x.reason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.HandshakeConstraintViolationException = HandshakeConstraintViolationException(this)
    }
}
