// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model



class CreatePolicyRequest private constructor(builder: Builder) {
    /**
     * The policy text content to add to the new policy. The text that you supply must adhere to the rules of the policy type you specify in the `Type` parameter.
     */
    val content: kotlin.String? = builder.content
    /**
     * An optional description to assign to the policy.
     */
    val description: kotlin.String? = builder.description
    /**
     * The friendly name to assign to the policy.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter is a string of any of the characters in the ASCII character range.
     */
    val name: kotlin.String? = builder.name
    /**
     * A list of tags that you want to attach to the newly created policy. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to `null`. For more information about tagging, see [Tagging Organizations resources](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html) in the Organizations User Guide.
     *
     * If any one of the tags is invalid or if you exceed the allowed number of tags for a policy, then the entire request fails and the policy is not created.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The type of policy to create. You can specify one of the following values:
     * + [AISERVICES_OPT_OUT_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
     * + [BACKUP_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
     * + [SERVICE_CONTROL_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html)
     * + [TAG_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
     */
    val type: aws.sdk.kotlin.services.organizations.model.PolicyType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.CreatePolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePolicyRequest(")
        append("content=$content,")
        append("description=$description,")
        append("name=$name,")
        append("tags=$tags,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePolicyRequest

        if (content != other.content) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.CreatePolicyRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The policy text content to add to the new policy. The text that you supply must adhere to the rules of the policy type you specify in the `Type` parameter.
         */
        var content: kotlin.String? = null
        /**
         * An optional description to assign to the policy.
         */
        var description: kotlin.String? = null
        /**
         * The friendly name to assign to the policy.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter is a string of any of the characters in the ASCII character range.
         */
        var name: kotlin.String? = null
        /**
         * A list of tags that you want to attach to the newly created policy. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to `null`. For more information about tagging, see [Tagging Organizations resources](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html) in the Organizations User Guide.
         *
         * If any one of the tags is invalid or if you exceed the allowed number of tags for a policy, then the entire request fails and the policy is not created.
         */
        var tags: List<Tag>? = null
        /**
         * The type of policy to create. You can specify one of the following values:
         * + [AISERVICES_OPT_OUT_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
         * + [BACKUP_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
         * + [SERVICE_CONTROL_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html)
         * + [TAG_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
         */
        var type: aws.sdk.kotlin.services.organizations.model.PolicyType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.CreatePolicyRequest) : this() {
            this.content = x.content
            this.description = x.description
            this.name = x.name
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.CreatePolicyRequest = CreatePolicyRequest(this)
    }
}
