// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.organizations.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the status about a CreateAccount or CreateGovCloudAccount request to create an Amazon Web Services account or an Amazon Web Services GovCloud (US) account in an organization.
 */
class CreateAccountStatus private constructor(builder: Builder) {
    /**
     * If the account was created successfully, the unique identifier (ID) of the new account.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for an account ID string requires exactly 12 digits.
     */
    val accountId: kotlin.String? = builder.accountId
    /**
     * The account name given to the account when it was created.
     */
    val accountName: kotlin.String? = builder.accountName
    /**
     * The date and time that the account was created and the request completed.
     */
    val completedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.completedTimestamp
    /**
     * If the request failed, a description of the reason for the failure.
     * + ACCOUNT_LIMIT_EXCEEDED: The account couldn't be created because you reached the limit on the number of accounts in your organization.
     * + CONCURRENT_ACCOUNT_MODIFICATION: You already submitted a request with the same information.
     * + EMAIL_ALREADY_EXISTS: The account could not be created because another Amazon Web Services account with that email address already exists.
     * + FAILED_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization failed to receive business license validation.
     * + GOVCLOUD_ACCOUNT_ALREADY_EXISTS: The account in the Amazon Web Services GovCloud (US) Region could not be created because this Region already includes an account with that email address.
     * + IDENTITY_INVALID_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization can't complete business license validation because it doesn't have valid identity data.
     * + INVALID_ADDRESS: The account could not be created because the address you provided is not valid.
     * + INVALID_EMAIL: The account could not be created because the email address you provided is not valid.
     * + INVALID_PAYMENT_INSTRUMENT: The Amazon Web Services account that owns your organization does not have a supported payment method associated with the account. Amazon Web Services does not support cards issued by financial institutions in Russia or Belarus. For more information, see [Managing your Amazon Web Services payments](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html).
     * + INTERNAL_FAILURE: The account could not be created because of an internal failure. Try again later. If the problem persists, contact Amazon Web Services Customer Support.
     * + MISSING_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization has not received Business Validation.
     * +  MISSING_PAYMENT_INSTRUMENT: You must configure the management account with a valid payment method, such as a credit card.
     * + PENDING_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization is still in the process of completing business license validation.
     * + UNKNOWN_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization has an unknown issue with business license validation.
     */
    val failureReason: aws.sdk.kotlin.services.organizations.model.CreateAccountFailureReason? = builder.failureReason
    /**
     * If the account was created successfully, the unique identifier (ID) of the new account in the Amazon Web Services GovCloud (US) Region.
     */
    val govCloudAccountId: kotlin.String? = builder.govCloudAccountId
    /**
     * The unique identifier (ID) that references this request. You get this value from the response of the initial CreateAccount request to create the account.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) for a create account request ID string requires "car-" followed by from 8 to 32 lowercase letters or digits.
     */
    val id: kotlin.String? = builder.id
    /**
     * The date and time that the request was made for the account creation.
     */
    val requestedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.requestedTimestamp
    /**
     * The status of the asynchronous request to create an Amazon Web Services account.
     */
    val state: aws.sdk.kotlin.services.organizations.model.CreateAccountState? = builder.state

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.organizations.model.CreateAccountStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAccountStatus(")
        append("accountId=$accountId,")
        append("accountName=*** Sensitive Data Redacted ***,")
        append("completedTimestamp=$completedTimestamp,")
        append("failureReason=$failureReason,")
        append("govCloudAccountId=$govCloudAccountId,")
        append("id=$id,")
        append("requestedTimestamp=$requestedTimestamp,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (accountName?.hashCode() ?: 0)
        result = 31 * result + (completedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (govCloudAccountId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (requestedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAccountStatus

        if (accountId != other.accountId) return false
        if (accountName != other.accountName) return false
        if (completedTimestamp != other.completedTimestamp) return false
        if (failureReason != other.failureReason) return false
        if (govCloudAccountId != other.govCloudAccountId) return false
        if (id != other.id) return false
        if (requestedTimestamp != other.requestedTimestamp) return false
        if (state != other.state) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.organizations.model.CreateAccountStatus = Builder(this).apply(block).build()

    class Builder {
        /**
         * If the account was created successfully, the unique identifier (ID) of the new account.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for an account ID string requires exactly 12 digits.
         */
        var accountId: kotlin.String? = null
        /**
         * The account name given to the account when it was created.
         */
        var accountName: kotlin.String? = null
        /**
         * The date and time that the account was created and the request completed.
         */
        var completedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If the request failed, a description of the reason for the failure.
         * + ACCOUNT_LIMIT_EXCEEDED: The account couldn't be created because you reached the limit on the number of accounts in your organization.
         * + CONCURRENT_ACCOUNT_MODIFICATION: You already submitted a request with the same information.
         * + EMAIL_ALREADY_EXISTS: The account could not be created because another Amazon Web Services account with that email address already exists.
         * + FAILED_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization failed to receive business license validation.
         * + GOVCLOUD_ACCOUNT_ALREADY_EXISTS: The account in the Amazon Web Services GovCloud (US) Region could not be created because this Region already includes an account with that email address.
         * + IDENTITY_INVALID_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization can't complete business license validation because it doesn't have valid identity data.
         * + INVALID_ADDRESS: The account could not be created because the address you provided is not valid.
         * + INVALID_EMAIL: The account could not be created because the email address you provided is not valid.
         * + INVALID_PAYMENT_INSTRUMENT: The Amazon Web Services account that owns your organization does not have a supported payment method associated with the account. Amazon Web Services does not support cards issued by financial institutions in Russia or Belarus. For more information, see [Managing your Amazon Web Services payments](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html).
         * + INTERNAL_FAILURE: The account could not be created because of an internal failure. Try again later. If the problem persists, contact Amazon Web Services Customer Support.
         * + MISSING_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization has not received Business Validation.
         * +  MISSING_PAYMENT_INSTRUMENT: You must configure the management account with a valid payment method, such as a credit card.
         * + PENDING_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization is still in the process of completing business license validation.
         * + UNKNOWN_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization has an unknown issue with business license validation.
         */
        var failureReason: aws.sdk.kotlin.services.organizations.model.CreateAccountFailureReason? = null
        /**
         * If the account was created successfully, the unique identifier (ID) of the new account in the Amazon Web Services GovCloud (US) Region.
         */
        var govCloudAccountId: kotlin.String? = null
        /**
         * The unique identifier (ID) that references this request. You get this value from the response of the initial CreateAccount request to create the account.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) for a create account request ID string requires "car-" followed by from 8 to 32 lowercase letters or digits.
         */
        var id: kotlin.String? = null
        /**
         * The date and time that the request was made for the account creation.
         */
        var requestedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the asynchronous request to create an Amazon Web Services account.
         */
        var state: aws.sdk.kotlin.services.organizations.model.CreateAccountState? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.organizations.model.CreateAccountStatus) : this() {
            this.accountId = x.accountId
            this.accountName = x.accountName
            this.completedTimestamp = x.completedTimestamp
            this.failureReason = x.failureReason
            this.govCloudAccountId = x.govCloudAccountId
            this.id = x.id
            this.requestedTimestamp = x.requestedTimestamp
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.organizations.model.CreateAccountStatus = CreateAccountStatus(this)
    }
}
