// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworkscm.serde

import aws.sdk.kotlin.services.opsworkscm.model.OpsWorksCmException
import aws.sdk.kotlin.services.opsworkscm.model.Server
import aws.sdk.kotlin.services.opsworkscm.model.UpdateServerEngineAttributesResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateServerEngineAttributesOperationDeserializer: HttpDeserializer.NonStreaming<UpdateServerEngineAttributesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateServerEngineAttributesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateServerEngineAttributesError(context, call, payload)
        }
        val builder = UpdateServerEngineAttributesResponse.Builder()

        if (payload != null) {
            deserializeUpdateServerEngineAttributesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateServerEngineAttributesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw OpsWorksCmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidStateException" -> InvalidStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> OpsWorksCmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateServerEngineAttributesOperationBody(builder: UpdateServerEngineAttributesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SERVER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Server"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SERVER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SERVER_DESCRIPTOR.index -> builder.server = deserializeServerDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
