// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworkscm.paginators

import aws.sdk.kotlin.services.opsworkscm.OpsWorksCmClient
import aws.sdk.kotlin.services.opsworkscm.model.Backup
import aws.sdk.kotlin.services.opsworkscm.model.DescribeBackupsRequest
import aws.sdk.kotlin.services.opsworkscm.model.DescribeBackupsResponse
import aws.sdk.kotlin.services.opsworkscm.model.DescribeEventsRequest
import aws.sdk.kotlin.services.opsworkscm.model.DescribeEventsResponse
import aws.sdk.kotlin.services.opsworkscm.model.DescribeServersRequest
import aws.sdk.kotlin.services.opsworkscm.model.DescribeServersResponse
import aws.sdk.kotlin.services.opsworkscm.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.opsworkscm.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.opsworkscm.model.Server
import aws.sdk.kotlin.services.opsworkscm.model.ServerEvent
import aws.sdk.kotlin.services.opsworkscm.model.Tag
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeBackupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeBackupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBackupsResponse]
 */
public fun OpsWorksCmClient.describeBackupsPaginated(initialRequest: DescribeBackupsRequest = DescribeBackupsRequest { }): Flow<DescribeBackupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeBackupsPaginated.describeBackups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeBackupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBackupsResponse]
 */
public fun OpsWorksCmClient.describeBackupsPaginated(block: DescribeBackupsRequest.Builder.() -> Unit): Flow<DescribeBackupsResponse> =
    describeBackupsPaginated(DescribeBackupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeBackupsPaginated]
 * to access the nested member [Backup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Backup]
 */
@JvmName("describeBackupsResponseBackup")
public fun Flow<DescribeBackupsResponse>.backups(): Flow<Backup> =
    transform() { response ->
        response.backups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventsResponse]
 */
public fun OpsWorksCmClient.describeEventsPaginated(initialRequest: DescribeEventsRequest): Flow<DescribeEventsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeEventsPaginated.describeEvents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventsResponse]
 */
public fun OpsWorksCmClient.describeEventsPaginated(block: DescribeEventsRequest.Builder.() -> Unit): Flow<DescribeEventsResponse> =
    describeEventsPaginated(DescribeEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEventsPaginated]
 * to access the nested member [ServerEvent]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServerEvent]
 */
@JvmName("describeEventsResponseServerEvent")
public fun Flow<DescribeEventsResponse>.serverEvents(): Flow<ServerEvent> =
    transform() { response ->
        response.serverEvents?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeServersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeServersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeServersResponse]
 */
public fun OpsWorksCmClient.describeServersPaginated(initialRequest: DescribeServersRequest = DescribeServersRequest { }): Flow<DescribeServersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeServersPaginated.describeServers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeServersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeServersResponse]
 */
public fun OpsWorksCmClient.describeServersPaginated(block: DescribeServersRequest.Builder.() -> Unit): Flow<DescribeServersResponse> =
    describeServersPaginated(DescribeServersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeServersPaginated]
 * to access the nested member [Server]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Server]
 */
@JvmName("describeServersResponseServer")
public fun Flow<DescribeServersResponse>.servers(): Flow<Server> =
    transform() { response ->
        response.servers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun OpsWorksCmClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun OpsWorksCmClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsForResourcePaginated]
 * to access the nested member [Tag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tag]
 */
@JvmName("listTagsForResourceResponseTag")
public fun Flow<ListTagsForResourceResponse>.tags(): Flow<Tag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }
