// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworkscm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a configuration management server.
 */
public class Server private constructor(builder: Builder) {
    /**
     * Associate a public IP address with a server that you are launching.
     */
    public val associatePublicIpAddress: kotlin.Boolean? = builder.associatePublicIpAddress
    /**
     * The number of automated backups to keep.
     */
    public val backupRetentionCount: kotlin.Int? = builder.backupRetentionCount
    /**
     * The ARN of the CloudFormation stack that was used to create the server.
     */
    public val cloudFormationStackArn: kotlin.String? = builder.cloudFormationStackArn
    /**
     * Time stamp of server creation. Example `2016-07-29T13:38:47.520Z`
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * An optional public endpoint of a server, such as `https://aws.my-company.com`. You cannot access the server by using the `Endpoint` value if the server has a `CustomDomain` specified.
     */
    public val customDomain: kotlin.String? = builder.customDomain
    /**
     * Disables automated backups. The number of stored backups is dependent on the value of PreferredBackupCount.
     */
    public val disableAutomatedBackup: kotlin.Boolean? = builder.disableAutomatedBackup
    /**
     * A DNS name that can be used to access the engine. Example: `myserver-asdfghjkl.us-east-1.opsworks.io`. You cannot access the server by using the `Endpoint` value if the server has a `CustomDomain` specified.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * The engine type of the server. Valid values in this release include `ChefAutomate` and `Puppet`.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The response of a createServer() request returns the master credential to access the server in EngineAttributes. These credentials are not stored by AWS OpsWorks CM; they are returned only as part of the result of createServer().
     *
     * **Attributes returned in a createServer response for Chef**
     * + `CHEF_AUTOMATE_PIVOTAL_KEY`: A base64-encoded RSA private key that is generated by AWS OpsWorks for Chef Automate. This private key is required to access the Chef API.
     * + `CHEF_STARTER_KIT`: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit, which includes a README, a configuration file, and the required RSA private key. Save this file, unzip it, and then change to the directory where you've unzipped the file contents. From this directory, you can run Knife commands.
     *
     * **Attributes returned in a createServer response for Puppet**
     * + `PUPPET_STARTER_KIT`: A base64-encoded ZIP file. The ZIP file contains a Puppet starter kit, including a README and a required private key. Save this file, unzip it, and then change to the directory where you've unzipped the file contents.
     * + `PUPPET_ADMIN_PASSWORD`: An administrator password that you can use to sign in to the Puppet Enterprise console after the server is online.
     */
    public val engineAttributes: List<EngineAttribute>? = builder.engineAttributes
    /**
     * The engine model of the server. Valid values in this release include `Monolithic` for Puppet and `Single` for Chef.
     */
    public val engineModel: kotlin.String? = builder.engineModel
    /**
     * The engine version of the server. For a Chef server, the valid value for EngineVersion is currently `2`. For a Puppet server, specify either `2019` or `2017`.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The instance profile ARN of the server.
     */
    public val instanceProfileArn: kotlin.String? = builder.instanceProfileArn
    /**
     * The instance type for the server, as specified in the CloudFormation stack. This might not be the same instance type that is shown in the EC2 console.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The key pair associated with the server.
     */
    public val keyPair: kotlin.String? = builder.keyPair
    /**
     * The status of the most recent server maintenance run. Shows `SUCCESS` or `FAILED`.
     */
    public val maintenanceStatus: aws.sdk.kotlin.services.opsworkscm.model.MaintenanceStatus? = builder.maintenanceStatus
    /**
     * The preferred backup period specified for the server.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The preferred maintenance period specified for the server.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * The security group IDs for the server, as specified in the CloudFormation stack. These might not be the same security groups that are shown in the EC2 console.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The ARN of the server.
     */
    public val serverArn: kotlin.String? = builder.serverArn
    /**
     * The name of the server.
     */
    public val serverName: kotlin.String? = builder.serverName
    /**
     * The service role ARN used to create the server.
     */
    public val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * The server's status. This field displays the states of actions in progress, such as creating, running, or backing up the server, as well as the server's health state.
     */
    public val status: aws.sdk.kotlin.services.opsworkscm.model.ServerStatus? = builder.status
    /**
     * Depending on the server status, this field has either a human-readable message (such as a create or backup error), or an escaped block of JSON (used for health check results).
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The subnet IDs specified in a CreateServer request.
     */
    public val subnetIds: List<String>? = builder.subnetIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworkscm.model.Server = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Server(")
        append("associatePublicIpAddress=$associatePublicIpAddress,")
        append("backupRetentionCount=$backupRetentionCount,")
        append("cloudFormationStackArn=$cloudFormationStackArn,")
        append("createdAt=$createdAt,")
        append("customDomain=$customDomain,")
        append("disableAutomatedBackup=$disableAutomatedBackup,")
        append("endpoint=$endpoint,")
        append("engine=$engine,")
        append("engineAttributes=$engineAttributes,")
        append("engineModel=$engineModel,")
        append("engineVersion=$engineVersion,")
        append("instanceProfileArn=$instanceProfileArn,")
        append("instanceType=$instanceType,")
        append("keyPair=$keyPair,")
        append("maintenanceStatus=$maintenanceStatus,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("securityGroupIds=$securityGroupIds,")
        append("serverArn=$serverArn,")
        append("serverName=$serverName,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("subnetIds=$subnetIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatePublicIpAddress?.hashCode() ?: 0
        result = 31 * result + (backupRetentionCount ?: 0)
        result = 31 * result + (cloudFormationStackArn?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (customDomain?.hashCode() ?: 0)
        result = 31 * result + (disableAutomatedBackup?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineAttributes?.hashCode() ?: 0)
        result = 31 * result + (engineModel?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileArn?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (keyPair?.hashCode() ?: 0)
        result = 31 * result + (maintenanceStatus?.hashCode() ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (serverArn?.hashCode() ?: 0)
        result = 31 * result + (serverName?.hashCode() ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Server

        if (associatePublicIpAddress != other.associatePublicIpAddress) return false
        if (backupRetentionCount != other.backupRetentionCount) return false
        if (cloudFormationStackArn != other.cloudFormationStackArn) return false
        if (createdAt != other.createdAt) return false
        if (customDomain != other.customDomain) return false
        if (disableAutomatedBackup != other.disableAutomatedBackup) return false
        if (endpoint != other.endpoint) return false
        if (engine != other.engine) return false
        if (engineAttributes != other.engineAttributes) return false
        if (engineModel != other.engineModel) return false
        if (engineVersion != other.engineVersion) return false
        if (instanceProfileArn != other.instanceProfileArn) return false
        if (instanceType != other.instanceType) return false
        if (keyPair != other.keyPair) return false
        if (maintenanceStatus != other.maintenanceStatus) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (serverArn != other.serverArn) return false
        if (serverName != other.serverName) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (subnetIds != other.subnetIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworkscm.model.Server = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Associate a public IP address with a server that you are launching.
         */
        public var associatePublicIpAddress: kotlin.Boolean? = null
        /**
         * The number of automated backups to keep.
         */
        public var backupRetentionCount: kotlin.Int? = null
        /**
         * The ARN of the CloudFormation stack that was used to create the server.
         */
        public var cloudFormationStackArn: kotlin.String? = null
        /**
         * Time stamp of server creation. Example `2016-07-29T13:38:47.520Z`
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An optional public endpoint of a server, such as `https://aws.my-company.com`. You cannot access the server by using the `Endpoint` value if the server has a `CustomDomain` specified.
         */
        public var customDomain: kotlin.String? = null
        /**
         * Disables automated backups. The number of stored backups is dependent on the value of PreferredBackupCount.
         */
        public var disableAutomatedBackup: kotlin.Boolean? = null
        /**
         * A DNS name that can be used to access the engine. Example: `myserver-asdfghjkl.us-east-1.opsworks.io`. You cannot access the server by using the `Endpoint` value if the server has a `CustomDomain` specified.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The engine type of the server. Valid values in this release include `ChefAutomate` and `Puppet`.
         */
        public var engine: kotlin.String? = null
        /**
         * The response of a createServer() request returns the master credential to access the server in EngineAttributes. These credentials are not stored by AWS OpsWorks CM; they are returned only as part of the result of createServer().
         *
         * **Attributes returned in a createServer response for Chef**
         * + `CHEF_AUTOMATE_PIVOTAL_KEY`: A base64-encoded RSA private key that is generated by AWS OpsWorks for Chef Automate. This private key is required to access the Chef API.
         * + `CHEF_STARTER_KIT`: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit, which includes a README, a configuration file, and the required RSA private key. Save this file, unzip it, and then change to the directory where you've unzipped the file contents. From this directory, you can run Knife commands.
         *
         * **Attributes returned in a createServer response for Puppet**
         * + `PUPPET_STARTER_KIT`: A base64-encoded ZIP file. The ZIP file contains a Puppet starter kit, including a README and a required private key. Save this file, unzip it, and then change to the directory where you've unzipped the file contents.
         * + `PUPPET_ADMIN_PASSWORD`: An administrator password that you can use to sign in to the Puppet Enterprise console after the server is online.
         */
        public var engineAttributes: List<EngineAttribute>? = null
        /**
         * The engine model of the server. Valid values in this release include `Monolithic` for Puppet and `Single` for Chef.
         */
        public var engineModel: kotlin.String? = null
        /**
         * The engine version of the server. For a Chef server, the valid value for EngineVersion is currently `2`. For a Puppet server, specify either `2019` or `2017`.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The instance profile ARN of the server.
         */
        public var instanceProfileArn: kotlin.String? = null
        /**
         * The instance type for the server, as specified in the CloudFormation stack. This might not be the same instance type that is shown in the EC2 console.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The key pair associated with the server.
         */
        public var keyPair: kotlin.String? = null
        /**
         * The status of the most recent server maintenance run. Shows `SUCCESS` or `FAILED`.
         */
        public var maintenanceStatus: aws.sdk.kotlin.services.opsworkscm.model.MaintenanceStatus? = null
        /**
         * The preferred backup period specified for the server.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The preferred maintenance period specified for the server.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * The security group IDs for the server, as specified in the CloudFormation stack. These might not be the same security groups that are shown in the EC2 console.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The ARN of the server.
         */
        public var serverArn: kotlin.String? = null
        /**
         * The name of the server.
         */
        public var serverName: kotlin.String? = null
        /**
         * The service role ARN used to create the server.
         */
        public var serviceRoleArn: kotlin.String? = null
        /**
         * The server's status. This field displays the states of actions in progress, such as creating, running, or backing up the server, as well as the server's health state.
         */
        public var status: aws.sdk.kotlin.services.opsworkscm.model.ServerStatus? = null
        /**
         * Depending on the server status, this field has either a human-readable message (such as a create or backup error), or an escaped block of JSON (used for health check results).
         */
        public var statusReason: kotlin.String? = null
        /**
         * The subnet IDs specified in a CreateServer request.
         */
        public var subnetIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworkscm.model.Server) : this() {
            this.associatePublicIpAddress = x.associatePublicIpAddress
            this.backupRetentionCount = x.backupRetentionCount
            this.cloudFormationStackArn = x.cloudFormationStackArn
            this.createdAt = x.createdAt
            this.customDomain = x.customDomain
            this.disableAutomatedBackup = x.disableAutomatedBackup
            this.endpoint = x.endpoint
            this.engine = x.engine
            this.engineAttributes = x.engineAttributes
            this.engineModel = x.engineModel
            this.engineVersion = x.engineVersion
            this.instanceProfileArn = x.instanceProfileArn
            this.instanceType = x.instanceType
            this.keyPair = x.keyPair
            this.maintenanceStatus = x.maintenanceStatus
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.securityGroupIds = x.securityGroupIds
            this.serverArn = x.serverArn
            this.serverName = x.serverName
            this.serviceRoleArn = x.serviceRoleArn
            this.status = x.status
            this.statusReason = x.statusReason
            this.subnetIds = x.subnetIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworkscm.model.Server = Server(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
