// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworkscm.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateServerRequest private constructor(builder: Builder) {
    /**
     * Associate a public IP address with a server that you are launching. Valid values are `true` or `false`. The default value is `true`.
     */
    public val associatePublicIpAddress: kotlin.Boolean? = builder.associatePublicIpAddress
    /**
     * If you specify this field, AWS OpsWorks CM creates the server by using the backup represented by BackupId.
     */
    public val backupId: kotlin.String? = builder.backupId
    /**
     * The number of automated backups that you want to keep. Whenever a new backup is created, AWS OpsWorks CM deletes the oldest backups if this number is exceeded. The default value is `1`.
     */
    public val backupRetentionCount: kotlin.Int? = builder.backupRetentionCount
    /**
     * A PEM-formatted HTTPS certificate. The value can be be a single, self-signed certificate, or a certificate chain. If you specify a custom certificate, you must also specify values for `CustomDomain` and `CustomPrivateKey`. The following are requirements for the `CustomCertificate` value:
     * + You can provide either a self-signed, custom certificate, or the full certificate chain.
     * + The certificate must be a valid X509 certificate, or a certificate chain in PEM format.
     * + The certificate must be valid at the time of upload. A certificate can't be used before its validity period begins (the certificate's `NotBefore` date), or after it expires (the certificate's `NotAfter` date).
     * + The certificate’s common name or subject alternative names (SANs), if present, must match the value of `CustomDomain`.
     * + The certificate must match the value of `CustomPrivateKey`.
     */
    public val customCertificate: kotlin.String? = builder.customCertificate
    /**
     * An optional public endpoint of a server, such as `https://aws.my-company.com`. To access the server, create a CNAME DNS record in your preferred DNS service that points the custom domain to the endpoint that is generated when the server is created (the value of the CreateServer Endpoint attribute). You cannot access the server by using the generated `Endpoint` value if the server is using a custom domain. If you specify a custom domain, you must also specify values for `CustomCertificate` and `CustomPrivateKey`.
     */
    public val customDomain: kotlin.String? = builder.customDomain
    /**
     * A private key in PEM format for connecting to the server by using HTTPS. The private key must not be encrypted; it cannot be protected by a password or passphrase. If you specify a custom private key, you must also specify values for `CustomDomain` and `CustomCertificate`.
     */
    public val customPrivateKey: kotlin.String? = builder.customPrivateKey
    /**
     * Enable or disable scheduled backups. Valid values are `true` or `false`. The default value is `true`.
     */
    public val disableAutomatedBackup: kotlin.Boolean? = builder.disableAutomatedBackup
    /**
     * The configuration management engine to use. Valid values include `ChefAutomate` and `Puppet`.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * Optional engine attributes on a specified server.
     *
     * **Attributes accepted in a Chef createServer request:**
     * + `CHEF_AUTOMATE_PIVOTAL_KEY`: A base64-encoded RSA public key. The corresponding private key is required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and returned in the response.
     * + `CHEF_AUTOMATE_ADMIN_PASSWORD`: The password for the administrative user in the Chef Automate web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password can contain letters, numbers, and special characters (!/@#$%^&+=_). The password must contain at least one lower case letter, one upper case letter, one number, and one special character. When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.
     *
     * **Attributes accepted in a Puppet createServer request:**
     * + `PUPPET_ADMIN_PASSWORD`: To work with the Puppet Enterprise console, a password must use ASCII characters.
     * + `PUPPET_R10K_REMOTE`: The r10k remote is the URL of your control repository (for example, ssh://git@your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.
     * + `PUPPET_R10K_PRIVATE_KEY`: If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.
     */
    public val engineAttributes: List<EngineAttribute>? = builder.engineAttributes
    /**
     * The engine model of the server. Valid values in this release include `Monolithic` for Puppet and `Single` for Chef.
     */
    public val engineModel: kotlin.String? = builder.engineModel
    /**
     * The major release version of the engine that you want to use. For a Chef server, the valid value for EngineVersion is currently `2`. For a Puppet server, valid values are `2019` or `2017`.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The ARN of the instance profile that your Amazon EC2 instances use. Although the AWS OpsWorks console typically creates the instance profile for you, if you are using API commands instead, run the service-role-creation.yaml AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template creates a CloudFormation stack that includes the instance profile you need.
     */
    public val instanceProfileArn: kotlin.String? = builder.instanceProfileArn
    /**
     * The Amazon EC2 instance type to use. For example, `m5.large`.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The Amazon EC2 key pair to set for the instance. This parameter is optional; if desired, you may specify this parameter to connect to your instances by using SSH.
     */
    public val keyPair: kotlin.String? = builder.keyPair
    /**
     * The start time for a one-hour period during which AWS OpsWorks CM backs up application-level data on your server if automated backups are enabled. Valid values must be specified in one of the following formats:
     * + `HH:MM` for daily backups
     * + `DDD:HH:MM` for weekly backups
     *
     * `MM` must be specified as `00`. The specified time is in coordinated universal time (UTC). The default value is a random, daily start time.
     *
     * **Example:**`08:00`, which represents a daily start time of 08:00 UTC.
     *
     * **Example:**`Mon:08:00`, which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The start time for a one-hour period each week during which AWS OpsWorks CM performs maintenance on the instance. Valid values must be specified in the following format: `DDD:HH:MM`. `MM` must be specified as `00`. The specified time is in coordinated universal time (UTC). The default value is a random one-hour period on Tuesday, Wednesday, or Friday. See `TimeWindowDefinition` for more information.
     *
     * **Example:**`Mon:08:00`, which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * A list of security group IDs to attach to the Amazon EC2 instance. If you add this parameter, the specified security groups must be within the VPC that is specified by `SubnetIds`.
     *
     *  If you do not specify this parameter, AWS OpsWorks CM creates one new security group that uses TCP ports 22 and 443, open to 0.0.0.0/0 (everyone).
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The name of the server. The server name must be unique within your AWS account, within each region. Server names must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a maximum of 40 characters.
     */
    public val serverName: kotlin.String? = builder.serverName
    /**
     * The service role that the AWS OpsWorks CM service backend uses to work with your account. Although the AWS OpsWorks management console typically creates the service role for you, if you are using the AWS CLI or API commands, run the service-role-creation.yaml AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template creates a CloudFormation stack that includes the service role and instance profile that you need.
     */
    public val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * The IDs of subnets in which to launch the server EC2 instance.
     *
     *  Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must have "Auto Assign Public IP" enabled.
     *
     *  EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are created in a default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must have "Auto Assign Public IP" enabled.
     *
     * For more information about supported Amazon EC2 platforms, see [Supported Platforms](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html).
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise server.
     * + The key cannot be empty.
     * + The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: `+ - = . _ : / @`
     * + The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: `+ - = . _ : / @`
     * + Leading and trailing white spaces are trimmed from both the key and value.
     * + A maximum of 50 user-applied tags is allowed for any AWS OpsWorks-CM server.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworkscm.model.CreateServerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateServerRequest(")
        append("associatePublicIpAddress=$associatePublicIpAddress,")
        append("backupId=$backupId,")
        append("backupRetentionCount=$backupRetentionCount,")
        append("customCertificate=$customCertificate,")
        append("customDomain=$customDomain,")
        append("customPrivateKey=*** Sensitive Data Redacted ***,")
        append("disableAutomatedBackup=$disableAutomatedBackup,")
        append("engine=$engine,")
        append("engineAttributes=$engineAttributes,")
        append("engineModel=$engineModel,")
        append("engineVersion=$engineVersion,")
        append("instanceProfileArn=$instanceProfileArn,")
        append("instanceType=$instanceType,")
        append("keyPair=$keyPair,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("securityGroupIds=$securityGroupIds,")
        append("serverName=$serverName,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatePublicIpAddress?.hashCode() ?: 0
        result = 31 * result + (backupId?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionCount ?: 0)
        result = 31 * result + (customCertificate?.hashCode() ?: 0)
        result = 31 * result + (customDomain?.hashCode() ?: 0)
        result = 31 * result + (customPrivateKey?.hashCode() ?: 0)
        result = 31 * result + (disableAutomatedBackup?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineAttributes?.hashCode() ?: 0)
        result = 31 * result + (engineModel?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileArn?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (keyPair?.hashCode() ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (serverName?.hashCode() ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateServerRequest

        if (associatePublicIpAddress != other.associatePublicIpAddress) return false
        if (backupId != other.backupId) return false
        if (backupRetentionCount != other.backupRetentionCount) return false
        if (customCertificate != other.customCertificate) return false
        if (customDomain != other.customDomain) return false
        if (customPrivateKey != other.customPrivateKey) return false
        if (disableAutomatedBackup != other.disableAutomatedBackup) return false
        if (engine != other.engine) return false
        if (engineAttributes != other.engineAttributes) return false
        if (engineModel != other.engineModel) return false
        if (engineVersion != other.engineVersion) return false
        if (instanceProfileArn != other.instanceProfileArn) return false
        if (instanceType != other.instanceType) return false
        if (keyPair != other.keyPair) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (serverName != other.serverName) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworkscm.model.CreateServerRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Associate a public IP address with a server that you are launching. Valid values are `true` or `false`. The default value is `true`.
         */
        public var associatePublicIpAddress: kotlin.Boolean? = null
        /**
         * If you specify this field, AWS OpsWorks CM creates the server by using the backup represented by BackupId.
         */
        public var backupId: kotlin.String? = null
        /**
         * The number of automated backups that you want to keep. Whenever a new backup is created, AWS OpsWorks CM deletes the oldest backups if this number is exceeded. The default value is `1`.
         */
        public var backupRetentionCount: kotlin.Int? = null
        /**
         * A PEM-formatted HTTPS certificate. The value can be be a single, self-signed certificate, or a certificate chain. If you specify a custom certificate, you must also specify values for `CustomDomain` and `CustomPrivateKey`. The following are requirements for the `CustomCertificate` value:
         * + You can provide either a self-signed, custom certificate, or the full certificate chain.
         * + The certificate must be a valid X509 certificate, or a certificate chain in PEM format.
         * + The certificate must be valid at the time of upload. A certificate can't be used before its validity period begins (the certificate's `NotBefore` date), or after it expires (the certificate's `NotAfter` date).
         * + The certificate’s common name or subject alternative names (SANs), if present, must match the value of `CustomDomain`.
         * + The certificate must match the value of `CustomPrivateKey`.
         */
        public var customCertificate: kotlin.String? = null
        /**
         * An optional public endpoint of a server, such as `https://aws.my-company.com`. To access the server, create a CNAME DNS record in your preferred DNS service that points the custom domain to the endpoint that is generated when the server is created (the value of the CreateServer Endpoint attribute). You cannot access the server by using the generated `Endpoint` value if the server is using a custom domain. If you specify a custom domain, you must also specify values for `CustomCertificate` and `CustomPrivateKey`.
         */
        public var customDomain: kotlin.String? = null
        /**
         * A private key in PEM format for connecting to the server by using HTTPS. The private key must not be encrypted; it cannot be protected by a password or passphrase. If you specify a custom private key, you must also specify values for `CustomDomain` and `CustomCertificate`.
         */
        public var customPrivateKey: kotlin.String? = null
        /**
         * Enable or disable scheduled backups. Valid values are `true` or `false`. The default value is `true`.
         */
        public var disableAutomatedBackup: kotlin.Boolean? = null
        /**
         * The configuration management engine to use. Valid values include `ChefAutomate` and `Puppet`.
         */
        public var engine: kotlin.String? = null
        /**
         * Optional engine attributes on a specified server.
         *
         * **Attributes accepted in a Chef createServer request:**
         * + `CHEF_AUTOMATE_PIVOTAL_KEY`: A base64-encoded RSA public key. The corresponding private key is required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and returned in the response.
         * + `CHEF_AUTOMATE_ADMIN_PASSWORD`: The password for the administrative user in the Chef Automate web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password can contain letters, numbers, and special characters (!/@#$%^&+=_). The password must contain at least one lower case letter, one upper case letter, one number, and one special character. When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.
         *
         * **Attributes accepted in a Puppet createServer request:**
         * + `PUPPET_ADMIN_PASSWORD`: To work with the Puppet Enterprise console, a password must use ASCII characters.
         * + `PUPPET_R10K_REMOTE`: The r10k remote is the URL of your control repository (for example, ssh://git@your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.
         * + `PUPPET_R10K_PRIVATE_KEY`: If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.
         */
        public var engineAttributes: List<EngineAttribute>? = null
        /**
         * The engine model of the server. Valid values in this release include `Monolithic` for Puppet and `Single` for Chef.
         */
        public var engineModel: kotlin.String? = null
        /**
         * The major release version of the engine that you want to use. For a Chef server, the valid value for EngineVersion is currently `2`. For a Puppet server, valid values are `2019` or `2017`.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The ARN of the instance profile that your Amazon EC2 instances use. Although the AWS OpsWorks console typically creates the instance profile for you, if you are using API commands instead, run the service-role-creation.yaml AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template creates a CloudFormation stack that includes the instance profile you need.
         */
        public var instanceProfileArn: kotlin.String? = null
        /**
         * The Amazon EC2 instance type to use. For example, `m5.large`.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The Amazon EC2 key pair to set for the instance. This parameter is optional; if desired, you may specify this parameter to connect to your instances by using SSH.
         */
        public var keyPair: kotlin.String? = null
        /**
         * The start time for a one-hour period during which AWS OpsWorks CM backs up application-level data on your server if automated backups are enabled. Valid values must be specified in one of the following formats:
         * + `HH:MM` for daily backups
         * + `DDD:HH:MM` for weekly backups
         *
         * `MM` must be specified as `00`. The specified time is in coordinated universal time (UTC). The default value is a random, daily start time.
         *
         * **Example:**`08:00`, which represents a daily start time of 08:00 UTC.
         *
         * **Example:**`Mon:08:00`, which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The start time for a one-hour period each week during which AWS OpsWorks CM performs maintenance on the instance. Valid values must be specified in the following format: `DDD:HH:MM`. `MM` must be specified as `00`. The specified time is in coordinated universal time (UTC). The default value is a random one-hour period on Tuesday, Wednesday, or Friday. See `TimeWindowDefinition` for more information.
         *
         * **Example:**`Mon:08:00`, which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * A list of security group IDs to attach to the Amazon EC2 instance. If you add this parameter, the specified security groups must be within the VPC that is specified by `SubnetIds`.
         *
         *  If you do not specify this parameter, AWS OpsWorks CM creates one new security group that uses TCP ports 22 and 443, open to 0.0.0.0/0 (everyone).
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The name of the server. The server name must be unique within your AWS account, within each region. Server names must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a maximum of 40 characters.
         */
        public var serverName: kotlin.String? = null
        /**
         * The service role that the AWS OpsWorks CM service backend uses to work with your account. Although the AWS OpsWorks management console typically creates the service role for you, if you are using the AWS CLI or API commands, run the service-role-creation.yaml AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template creates a CloudFormation stack that includes the service role and instance profile that you need.
         */
        public var serviceRoleArn: kotlin.String? = null
        /**
         * The IDs of subnets in which to launch the server EC2 instance.
         *
         *  Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must have "Auto Assign Public IP" enabled.
         *
         *  EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are created in a default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must have "Auto Assign Public IP" enabled.
         *
         * For more information about supported Amazon EC2 platforms, see [Supported Platforms](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html).
         */
        public var subnetIds: List<String>? = null
        /**
         * A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise server.
         * + The key cannot be empty.
         * + The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: `+ - = . _ : / @`
         * + The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: `+ - = . _ : / @`
         * + Leading and trailing white spaces are trimmed from both the key and value.
         * + A maximum of 50 user-applied tags is allowed for any AWS OpsWorks-CM server.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworkscm.model.CreateServerRequest) : this() {
            this.associatePublicIpAddress = x.associatePublicIpAddress
            this.backupId = x.backupId
            this.backupRetentionCount = x.backupRetentionCount
            this.customCertificate = x.customCertificate
            this.customDomain = x.customDomain
            this.customPrivateKey = x.customPrivateKey
            this.disableAutomatedBackup = x.disableAutomatedBackup
            this.engine = x.engine
            this.engineAttributes = x.engineAttributes
            this.engineModel = x.engineModel
            this.engineVersion = x.engineVersion
            this.instanceProfileArn = x.instanceProfileArn
            this.instanceType = x.instanceType
            this.keyPair = x.keyPair
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.securityGroupIds = x.securityGroupIds
            this.serverName = x.serverName
            this.serviceRoleArn = x.serviceRoleArn
            this.subnetIds = x.subnetIds
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworkscm.model.CreateServerRequest = CreateServerRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
