// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworkscm.serde

import aws.sdk.kotlin.services.opsworkscm.model.OpsWorksCmException
import aws.sdk.kotlin.services.opsworkscm.model.Server
import aws.sdk.kotlin.services.opsworkscm.model.StartMaintenanceResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartMaintenanceOperationDeserializer: HttpDeserialize<StartMaintenanceResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): StartMaintenanceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartMaintenanceError(context, call)
        }
        val builder = StartMaintenanceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartMaintenanceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwStartMaintenanceError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw OpsWorksCmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidStateException" -> InvalidStateExceptionDeserializer().deserialize(context, wrappedCall)
        else -> OpsWorksCmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartMaintenanceOperationBody(builder: StartMaintenanceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SERVER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Server"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SERVER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SERVER_DESCRIPTOR.index -> builder.server = deserializeServerDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
