// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworkscm

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.opsworkscm.auth.DefaultOpsWorksCmAuthSchemeProvider
import aws.sdk.kotlin.services.opsworkscm.auth.OpsWorksCmAuthSchemeProvider
import aws.sdk.kotlin.services.opsworkscm.endpoints.DefaultOpsWorksCmEndpointProvider
import aws.sdk.kotlin.services.opsworkscm.endpoints.OpsWorksCmEndpointParameters
import aws.sdk.kotlin.services.opsworkscm.endpoints.OpsWorksCmEndpointProvider
import aws.sdk.kotlin.services.opsworkscm.model.AssociateNodeRequest
import aws.sdk.kotlin.services.opsworkscm.model.AssociateNodeResponse
import aws.sdk.kotlin.services.opsworkscm.model.CreateBackupRequest
import aws.sdk.kotlin.services.opsworkscm.model.CreateBackupResponse
import aws.sdk.kotlin.services.opsworkscm.model.CreateServerRequest
import aws.sdk.kotlin.services.opsworkscm.model.CreateServerResponse
import aws.sdk.kotlin.services.opsworkscm.model.DeleteBackupRequest
import aws.sdk.kotlin.services.opsworkscm.model.DeleteBackupResponse
import aws.sdk.kotlin.services.opsworkscm.model.DeleteServerRequest
import aws.sdk.kotlin.services.opsworkscm.model.DeleteServerResponse
import aws.sdk.kotlin.services.opsworkscm.model.DescribeAccountAttributesRequest
import aws.sdk.kotlin.services.opsworkscm.model.DescribeAccountAttributesResponse
import aws.sdk.kotlin.services.opsworkscm.model.DescribeBackupsRequest
import aws.sdk.kotlin.services.opsworkscm.model.DescribeBackupsResponse
import aws.sdk.kotlin.services.opsworkscm.model.DescribeEventsRequest
import aws.sdk.kotlin.services.opsworkscm.model.DescribeEventsResponse
import aws.sdk.kotlin.services.opsworkscm.model.DescribeNodeAssociationStatusRequest
import aws.sdk.kotlin.services.opsworkscm.model.DescribeNodeAssociationStatusResponse
import aws.sdk.kotlin.services.opsworkscm.model.DescribeServersRequest
import aws.sdk.kotlin.services.opsworkscm.model.DescribeServersResponse
import aws.sdk.kotlin.services.opsworkscm.model.DisassociateNodeRequest
import aws.sdk.kotlin.services.opsworkscm.model.DisassociateNodeResponse
import aws.sdk.kotlin.services.opsworkscm.model.ExportServerEngineAttributeRequest
import aws.sdk.kotlin.services.opsworkscm.model.ExportServerEngineAttributeResponse
import aws.sdk.kotlin.services.opsworkscm.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.opsworkscm.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.opsworkscm.model.RestoreServerRequest
import aws.sdk.kotlin.services.opsworkscm.model.RestoreServerResponse
import aws.sdk.kotlin.services.opsworkscm.model.StartMaintenanceRequest
import aws.sdk.kotlin.services.opsworkscm.model.StartMaintenanceResponse
import aws.sdk.kotlin.services.opsworkscm.model.TagResourceRequest
import aws.sdk.kotlin.services.opsworkscm.model.TagResourceResponse
import aws.sdk.kotlin.services.opsworkscm.model.UntagResourceRequest
import aws.sdk.kotlin.services.opsworkscm.model.UntagResourceResponse
import aws.sdk.kotlin.services.opsworkscm.model.UpdateServerEngineAttributesRequest
import aws.sdk.kotlin.services.opsworkscm.model.UpdateServerEngineAttributesResponse
import aws.sdk.kotlin.services.opsworkscm.model.UpdateServerRequest
import aws.sdk.kotlin.services.opsworkscm.model.UpdateServerResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "OpsWorksCM"
public const val SdkVersion: String = "0.32.1-beta"

/**
 * # AWS OpsWorks CM
 * AWS OpsWorks for configuration management (CM) is a service that runs and manages configuration management servers. You can use AWS OpsWorks CM to create and manage AWS OpsWorks for Chef Automate and AWS OpsWorks for Puppet Enterprise servers, and add or remove nodes for the servers to manage.
 *
 * **Glossary of terms**
 * + **Server**: A configuration management server that can be highly-available. The configuration management server runs on an Amazon Elastic Compute Cloud (EC2) instance, and may use various other AWS services, such as Amazon Relational Database Service (RDS) and Elastic Load Balancing. A server is a generic abstraction over the configuration manager that you want to use, much like Amazon RDS. In AWS OpsWorks CM, you do not start or stop servers. After you create servers, they continue to run until they are deleted.
 * + **Engine**: The engine is the specific configuration manager that you want to use. Valid values in this release include `ChefAutomate` and `Puppet`.
 * + **Backup**: This is an application-level backup of the data that the configuration manager stores. AWS OpsWorks CM creates an S3 bucket for backups when you launch the first server. A backup maintains a snapshot of a server's configuration-related attributes at the time the backup starts.
 * + **Events**: Events are always related to a server. Events are written during server creation, when health checks run, when backups are created, when system maintenance is performed, etc. When you delete a server, the server's events are also deleted.
 * + **Account attributes**: Every account has attributes that are assigned in the AWS OpsWorks CM database. These attributes store information about configuration limits (servers, backups, etc.) and your customer account.
 *
 * **Endpoints**
 *
 * AWS OpsWorks CM supports the following endpoints, all HTTPS. You must connect to one of the following endpoints. Your servers can only be accessed or managed within the endpoint in which they are created.
 * + opsworks-cm.us-east-1.amazonaws.com
 * + opsworks-cm.us-east-2.amazonaws.com
 * + opsworks-cm.us-west-1.amazonaws.com
 * + opsworks-cm.us-west-2.amazonaws.com
 * + opsworks-cm.ap-northeast-1.amazonaws.com
 * + opsworks-cm.ap-southeast-1.amazonaws.com
 * + opsworks-cm.ap-southeast-2.amazonaws.com
 * + opsworks-cm.eu-central-1.amazonaws.com
 * + opsworks-cm.eu-west-1.amazonaws.com
 *
 * For more information, see [AWS OpsWorks endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/opsworks-service.html) in the AWS General Reference.
 *
 * **Throttling limits**
 *
 * All API operations allow for five requests per second with a burst of 10 requests per second.
 */
public interface OpsWorksCmClient : SdkClient {
    /**
     * OpsWorksCmClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, OpsWorksCmClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "OpsWorksCm",
                "OPSWORKSCM",
                "opsworkscm",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, OpsWorksCmClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): OpsWorksCmClient = DefaultOpsWorksCmClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        public val authSchemeProvider: OpsWorksCmAuthSchemeProvider = builder.authSchemeProvider ?: DefaultOpsWorksCmAuthSchemeProvider
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: OpsWorksCmEndpointProvider = builder.endpointProvider ?: DefaultOpsWorksCmEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemeProvider = this@Config.authSchemeProvider
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "OpsWorksCM"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: OpsWorksCmAuthSchemeProvider? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: OpsWorksCmEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a new node with the server. For more information about how to disassociate a node, see DisassociateNode.
     *
     *  On a Chef server: This command is an alternative to `knife bootstrap`.
     *
     *  Example (Chef): `aws opsworks-cm associate-node --server-name <i>MyServer</i> --node-name <i>MyManagedNode</i> --engine-attributes "Name=<i>CHEF_ORGANIZATION</i>,Value=default" "Name=<i>CHEF_NODE_PUBLIC_KEY</i>,Value=<i>public-key-pem</i>"`
     *
     *  On a Puppet server, this command is an alternative to the `puppet cert sign` command that signs a Puppet node CSR.
     *
     *  Example (Puppet): `aws opsworks-cm associate-node --server-name <i>MyServer</i> --node-name <i>MyManagedNode</i> --engine-attributes "Name=<i>PUPPET_NODE_CSR</i>,Value=<i>csr-pem</i>"`
     *
     *  A node can can only be associated with servers that are in a `HEALTHY` state. Otherwise, an `InvalidStateException` is thrown. A `ResourceNotFoundException` is thrown when the server does not exist. A `ValidationException` is raised when parameters of the request are not valid. The AssociateNode API call can be integrated into Auto Scaling configurations, AWS Cloudformation templates, or the user data of a server's instance.
     */
    public suspend fun associateNode(input: AssociateNodeRequest): AssociateNodeResponse

    /**
     * Creates an application-level backup of a server. While the server is in the `BACKING_UP` state, the server cannot be changed, and no additional backup can be created.
     *
     *  Backups can be created for servers in `RUNNING`, `HEALTHY`, and `UNHEALTHY` states. By default, you can create a maximum of 50 manual backups.
     *
     *  This operation is asynchronous.
     *
     *  A `LimitExceededException` is thrown when the maximum number of manual backups is reached. An `InvalidStateException` is thrown when the server is not in any of the following states: RUNNING, HEALTHY, or UNHEALTHY. A `ResourceNotFoundException` is thrown when the server is not found. A `ValidationException` is thrown when parameters of the request are not valid.
     */
    public suspend fun createBackup(input: CreateBackupRequest): CreateBackupResponse

    /**
     * Creates and immedately starts a new server. The server is ready to use when it is in the `HEALTHY` state. By default, you can create a maximum of 10 servers.
     *
     *  This operation is asynchronous.
     *
     *  A `LimitExceededException` is thrown when you have created the maximum number of servers (10). A `ResourceAlreadyExistsException` is thrown when a server with the same name already exists in the account. A `ResourceNotFoundException` is thrown when you specify a backup ID that is not valid or is for a backup that does not exist. A `ValidationException` is thrown when parameters of the request are not valid.
     *
     *  If you do not specify a security group by adding the `SecurityGroupIds` parameter, AWS OpsWorks creates a new security group.
     *
     * *Chef Automate:* The default security group opens the Chef server to the world on TCP port 443. If a KeyName is present, AWS OpsWorks enables SSH access. SSH is also open to the world on TCP port 22.
     *
     * *Puppet Enterprise:* The default security group opens TCP ports 22, 443, 4433, 8140, 8142, 8143, and 8170. If a KeyName is present, AWS OpsWorks enables SSH access. SSH is also open to the world on TCP port 22.
     *
     * By default, your server is accessible from any IP address. We recommend that you update your security group rules to allow access from known IP addresses and address ranges only. To edit security group rules, open Security Groups in the navigation pane of the EC2 management console.
     *
     * To specify your own domain for a server, and provide your own self-signed or CA-signed certificate and private key, specify values for `CustomDomain`, `CustomCertificate`, and `CustomPrivateKey`.
     */
    public suspend fun createServer(input: CreateServerRequest): CreateServerResponse

    /**
     * Deletes a backup. You can delete both manual and automated backups. This operation is asynchronous.
     *
     *  An `InvalidStateException` is thrown when a backup deletion is already in progress. A `ResourceNotFoundException` is thrown when the backup does not exist. A `ValidationException` is thrown when parameters of the request are not valid.
     */
    public suspend fun deleteBackup(input: DeleteBackupRequest): DeleteBackupResponse

    /**
     * Deletes the server and the underlying AWS CloudFormation stacks (including the server's EC2 instance). When you run this command, the server state is updated to `DELETING`. After the server is deleted, it is no longer returned by `DescribeServer` requests. If the AWS CloudFormation stack cannot be deleted, the server cannot be deleted.
     *
     *  This operation is asynchronous.
     *
     *  An `InvalidStateException` is thrown when a server deletion is already in progress. A `ResourceNotFoundException` is thrown when the server does not exist. A `ValidationException` is raised when parameters of the request are not valid.
     */
    public suspend fun deleteServer(input: DeleteServerRequest): DeleteServerResponse

    /**
     * Describes your OpsWorks-CM account attributes.
     *
     *  This operation is synchronous.
     */
    public suspend fun describeAccountAttributes(input: DescribeAccountAttributesRequest = DescribeAccountAttributesRequest {}): DescribeAccountAttributesResponse

    /**
     * Describes backups. The results are ordered by time, with newest backups first. If you do not specify a BackupId or ServerName, the command returns all backups.
     *
     *  This operation is synchronous.
     *
     *  A `ResourceNotFoundException` is thrown when the backup does not exist. A `ValidationException` is raised when parameters of the request are not valid.
     */
    public suspend fun describeBackups(input: DescribeBackupsRequest = DescribeBackupsRequest {}): DescribeBackupsResponse

    /**
     * Describes events for a specified server. Results are ordered by time, with newest events first.
     *
     *  This operation is synchronous.
     *
     *  A `ResourceNotFoundException` is thrown when the server does not exist. A `ValidationException` is raised when parameters of the request are not valid.
     */
    public suspend fun describeEvents(input: DescribeEventsRequest): DescribeEventsResponse

    /**
     * Returns the current status of an existing association or disassociation request.
     *
     *  A `ResourceNotFoundException` is thrown when no recent association or disassociation request with the specified token is found, or when the server does not exist. A `ValidationException` is raised when parameters of the request are not valid.
     */
    public suspend fun describeNodeAssociationStatus(input: DescribeNodeAssociationStatusRequest): DescribeNodeAssociationStatusResponse

    /**
     * Lists all configuration management servers that are identified with your account. Only the stored results from Amazon DynamoDB are returned. AWS OpsWorks CM does not query other services.
     *
     *  This operation is synchronous.
     *
     *  A `ResourceNotFoundException` is thrown when the server does not exist. A `ValidationException` is raised when parameters of the request are not valid.
     */
    public suspend fun describeServers(input: DescribeServersRequest = DescribeServersRequest {}): DescribeServersResponse

    /**
     * Disassociates a node from an AWS OpsWorks CM server, and removes the node from the server's managed nodes. After a node is disassociated, the node key pair is no longer valid for accessing the configuration manager's API. For more information about how to associate a node, see AssociateNode.
     *
     * A node can can only be disassociated from a server that is in a `HEALTHY` state. Otherwise, an `InvalidStateException` is thrown. A `ResourceNotFoundException` is thrown when the server does not exist. A `ValidationException` is raised when parameters of the request are not valid.
     */
    public suspend fun disassociateNode(input: DisassociateNodeRequest): DisassociateNodeResponse

    /**
     * Exports a specified server engine attribute as a base64-encoded string. For example, you can export user data that you can use in EC2 to associate nodes with a server.
     *
     *  This operation is synchronous.
     *
     *  A `ValidationException` is raised when parameters of the request are not valid. A `ResourceNotFoundException` is thrown when the server does not exist. An `InvalidStateException` is thrown when the server is in any of the following states: CREATING, TERMINATED, FAILED or DELETING.
     */
    public suspend fun exportServerEngineAttribute(input: ExportServerEngineAttributeRequest): ExportServerEngineAttributeResponse

    /**
     * Returns a list of tags that are applied to the specified AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise servers or backups.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Restores a backup to a server that is in a `CONNECTION_LOST`, `HEALTHY`, `RUNNING`, `UNHEALTHY`, or `TERMINATED` state. When you run RestoreServer, the server's EC2 instance is deleted, and a new EC2 instance is configured. RestoreServer maintains the existing server endpoint, so configuration management of the server's client devices (nodes) should continue to work.
     *
     * Restoring from a backup is performed by creating a new EC2 instance. If restoration is successful, and the server is in a `HEALTHY` state, AWS OpsWorks CM switches traffic over to the new instance. After restoration is finished, the old EC2 instance is maintained in a `Running` or `Stopped` state, but is eventually terminated.
     *
     *  This operation is asynchronous.
     *
     *  An `InvalidStateException` is thrown when the server is not in a valid state. A `ResourceNotFoundException` is thrown when the server does not exist. A `ValidationException` is raised when parameters of the request are not valid.
     */
    public suspend fun restoreServer(input: RestoreServerRequest): RestoreServerResponse

    /**
     * Manually starts server maintenance. This command can be useful if an earlier maintenance attempt failed, and the underlying cause of maintenance failure has been resolved. The server is in an `UNDER_MAINTENANCE` state while maintenance is in progress.
     *
     *  Maintenance can only be started on servers in `HEALTHY` and `UNHEALTHY` states. Otherwise, an `InvalidStateException` is thrown. A `ResourceNotFoundException` is thrown when the server does not exist. A `ValidationException` is raised when parameters of the request are not valid.
     */
    public suspend fun startMaintenance(input: StartMaintenanceRequest): StartMaintenanceResponse

    /**
     * Applies tags to an AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise server, or to server backups.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes specified tags from an AWS OpsWorks-CM server or backup.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates settings for a server.
     *
     *  This operation is synchronous.
     */
    public suspend fun updateServer(input: UpdateServerRequest): UpdateServerResponse

    /**
     * Updates engine-specific attributes on a specified server. The server enters the `MODIFYING` state when this operation is in progress. Only one update can occur at a time. You can use this command to reset a Chef server's public key (`CHEF_PIVOTAL_KEY`) or a Puppet server's admin password (`PUPPET_ADMIN_PASSWORD`).
     *
     *  This operation is asynchronous.
     *
     *  This operation can only be called for servers in `HEALTHY` or `UNHEALTHY` states. Otherwise, an `InvalidStateException` is raised. A `ResourceNotFoundException` is thrown when the server does not exist. A `ValidationException` is raised when parameters of the request are not valid.
     */
    public suspend fun updateServerEngineAttributes(input: UpdateServerEngineAttributesRequest): UpdateServerEngineAttributesResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun OpsWorksCmClient.withConfig(block: OpsWorksCmClient.Config.Builder.() -> Unit): OpsWorksCmClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultOpsWorksCmClient(newConfig)
}

/**
 * Associates a new node with the server. For more information about how to disassociate a node, see DisassociateNode.
 *
 *  On a Chef server: This command is an alternative to `knife bootstrap`.
 *
 *  Example (Chef): `aws opsworks-cm associate-node --server-name <i>MyServer</i> --node-name <i>MyManagedNode</i> --engine-attributes "Name=<i>CHEF_ORGANIZATION</i>,Value=default" "Name=<i>CHEF_NODE_PUBLIC_KEY</i>,Value=<i>public-key-pem</i>"`
 *
 *  On a Puppet server, this command is an alternative to the `puppet cert sign` command that signs a Puppet node CSR.
 *
 *  Example (Puppet): `aws opsworks-cm associate-node --server-name <i>MyServer</i> --node-name <i>MyManagedNode</i> --engine-attributes "Name=<i>PUPPET_NODE_CSR</i>,Value=<i>csr-pem</i>"`
 *
 *  A node can can only be associated with servers that are in a `HEALTHY` state. Otherwise, an `InvalidStateException` is thrown. A `ResourceNotFoundException` is thrown when the server does not exist. A `ValidationException` is raised when parameters of the request are not valid. The AssociateNode API call can be integrated into Auto Scaling configurations, AWS Cloudformation templates, or the user data of a server's instance.
 */
public suspend inline fun OpsWorksCmClient.associateNode(crossinline block: AssociateNodeRequest.Builder.() -> Unit): AssociateNodeResponse = associateNode(AssociateNodeRequest.Builder().apply(block).build())

/**
 * Creates an application-level backup of a server. While the server is in the `BACKING_UP` state, the server cannot be changed, and no additional backup can be created.
 *
 *  Backups can be created for servers in `RUNNING`, `HEALTHY`, and `UNHEALTHY` states. By default, you can create a maximum of 50 manual backups.
 *
 *  This operation is asynchronous.
 *
 *  A `LimitExceededException` is thrown when the maximum number of manual backups is reached. An `InvalidStateException` is thrown when the server is not in any of the following states: RUNNING, HEALTHY, or UNHEALTHY. A `ResourceNotFoundException` is thrown when the server is not found. A `ValidationException` is thrown when parameters of the request are not valid.
 */
public suspend inline fun OpsWorksCmClient.createBackup(crossinline block: CreateBackupRequest.Builder.() -> Unit): CreateBackupResponse = createBackup(CreateBackupRequest.Builder().apply(block).build())

/**
 * Creates and immedately starts a new server. The server is ready to use when it is in the `HEALTHY` state. By default, you can create a maximum of 10 servers.
 *
 *  This operation is asynchronous.
 *
 *  A `LimitExceededException` is thrown when you have created the maximum number of servers (10). A `ResourceAlreadyExistsException` is thrown when a server with the same name already exists in the account. A `ResourceNotFoundException` is thrown when you specify a backup ID that is not valid or is for a backup that does not exist. A `ValidationException` is thrown when parameters of the request are not valid.
 *
 *  If you do not specify a security group by adding the `SecurityGroupIds` parameter, AWS OpsWorks creates a new security group.
 *
 * *Chef Automate:* The default security group opens the Chef server to the world on TCP port 443. If a KeyName is present, AWS OpsWorks enables SSH access. SSH is also open to the world on TCP port 22.
 *
 * *Puppet Enterprise:* The default security group opens TCP ports 22, 443, 4433, 8140, 8142, 8143, and 8170. If a KeyName is present, AWS OpsWorks enables SSH access. SSH is also open to the world on TCP port 22.
 *
 * By default, your server is accessible from any IP address. We recommend that you update your security group rules to allow access from known IP addresses and address ranges only. To edit security group rules, open Security Groups in the navigation pane of the EC2 management console.
 *
 * To specify your own domain for a server, and provide your own self-signed or CA-signed certificate and private key, specify values for `CustomDomain`, `CustomCertificate`, and `CustomPrivateKey`.
 */
public suspend inline fun OpsWorksCmClient.createServer(crossinline block: CreateServerRequest.Builder.() -> Unit): CreateServerResponse = createServer(CreateServerRequest.Builder().apply(block).build())

/**
 * Deletes a backup. You can delete both manual and automated backups. This operation is asynchronous.
 *
 *  An `InvalidStateException` is thrown when a backup deletion is already in progress. A `ResourceNotFoundException` is thrown when the backup does not exist. A `ValidationException` is thrown when parameters of the request are not valid.
 */
public suspend inline fun OpsWorksCmClient.deleteBackup(crossinline block: DeleteBackupRequest.Builder.() -> Unit): DeleteBackupResponse = deleteBackup(DeleteBackupRequest.Builder().apply(block).build())

/**
 * Deletes the server and the underlying AWS CloudFormation stacks (including the server's EC2 instance). When you run this command, the server state is updated to `DELETING`. After the server is deleted, it is no longer returned by `DescribeServer` requests. If the AWS CloudFormation stack cannot be deleted, the server cannot be deleted.
 *
 *  This operation is asynchronous.
 *
 *  An `InvalidStateException` is thrown when a server deletion is already in progress. A `ResourceNotFoundException` is thrown when the server does not exist. A `ValidationException` is raised when parameters of the request are not valid.
 */
public suspend inline fun OpsWorksCmClient.deleteServer(crossinline block: DeleteServerRequest.Builder.() -> Unit): DeleteServerResponse = deleteServer(DeleteServerRequest.Builder().apply(block).build())

/**
 * Describes your OpsWorks-CM account attributes.
 *
 *  This operation is synchronous.
 */
public suspend inline fun OpsWorksCmClient.describeAccountAttributes(crossinline block: DescribeAccountAttributesRequest.Builder.() -> Unit): DescribeAccountAttributesResponse = describeAccountAttributes(DescribeAccountAttributesRequest.Builder().apply(block).build())

/**
 * Describes backups. The results are ordered by time, with newest backups first. If you do not specify a BackupId or ServerName, the command returns all backups.
 *
 *  This operation is synchronous.
 *
 *  A `ResourceNotFoundException` is thrown when the backup does not exist. A `ValidationException` is raised when parameters of the request are not valid.
 */
public suspend inline fun OpsWorksCmClient.describeBackups(crossinline block: DescribeBackupsRequest.Builder.() -> Unit): DescribeBackupsResponse = describeBackups(DescribeBackupsRequest.Builder().apply(block).build())

/**
 * Describes events for a specified server. Results are ordered by time, with newest events first.
 *
 *  This operation is synchronous.
 *
 *  A `ResourceNotFoundException` is thrown when the server does not exist. A `ValidationException` is raised when parameters of the request are not valid.
 */
public suspend inline fun OpsWorksCmClient.describeEvents(crossinline block: DescribeEventsRequest.Builder.() -> Unit): DescribeEventsResponse = describeEvents(DescribeEventsRequest.Builder().apply(block).build())

/**
 * Returns the current status of an existing association or disassociation request.
 *
 *  A `ResourceNotFoundException` is thrown when no recent association or disassociation request with the specified token is found, or when the server does not exist. A `ValidationException` is raised when parameters of the request are not valid.
 */
public suspend inline fun OpsWorksCmClient.describeNodeAssociationStatus(crossinline block: DescribeNodeAssociationStatusRequest.Builder.() -> Unit): DescribeNodeAssociationStatusResponse = describeNodeAssociationStatus(DescribeNodeAssociationStatusRequest.Builder().apply(block).build())

/**
 * Lists all configuration management servers that are identified with your account. Only the stored results from Amazon DynamoDB are returned. AWS OpsWorks CM does not query other services.
 *
 *  This operation is synchronous.
 *
 *  A `ResourceNotFoundException` is thrown when the server does not exist. A `ValidationException` is raised when parameters of the request are not valid.
 */
public suspend inline fun OpsWorksCmClient.describeServers(crossinline block: DescribeServersRequest.Builder.() -> Unit): DescribeServersResponse = describeServers(DescribeServersRequest.Builder().apply(block).build())

/**
 * Disassociates a node from an AWS OpsWorks CM server, and removes the node from the server's managed nodes. After a node is disassociated, the node key pair is no longer valid for accessing the configuration manager's API. For more information about how to associate a node, see AssociateNode.
 *
 * A node can can only be disassociated from a server that is in a `HEALTHY` state. Otherwise, an `InvalidStateException` is thrown. A `ResourceNotFoundException` is thrown when the server does not exist. A `ValidationException` is raised when parameters of the request are not valid.
 */
public suspend inline fun OpsWorksCmClient.disassociateNode(crossinline block: DisassociateNodeRequest.Builder.() -> Unit): DisassociateNodeResponse = disassociateNode(DisassociateNodeRequest.Builder().apply(block).build())

/**
 * Exports a specified server engine attribute as a base64-encoded string. For example, you can export user data that you can use in EC2 to associate nodes with a server.
 *
 *  This operation is synchronous.
 *
 *  A `ValidationException` is raised when parameters of the request are not valid. A `ResourceNotFoundException` is thrown when the server does not exist. An `InvalidStateException` is thrown when the server is in any of the following states: CREATING, TERMINATED, FAILED or DELETING.
 */
public suspend inline fun OpsWorksCmClient.exportServerEngineAttribute(crossinline block: ExportServerEngineAttributeRequest.Builder.() -> Unit): ExportServerEngineAttributeResponse = exportServerEngineAttribute(ExportServerEngineAttributeRequest.Builder().apply(block).build())

/**
 * Returns a list of tags that are applied to the specified AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise servers or backups.
 */
public suspend inline fun OpsWorksCmClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Restores a backup to a server that is in a `CONNECTION_LOST`, `HEALTHY`, `RUNNING`, `UNHEALTHY`, or `TERMINATED` state. When you run RestoreServer, the server's EC2 instance is deleted, and a new EC2 instance is configured. RestoreServer maintains the existing server endpoint, so configuration management of the server's client devices (nodes) should continue to work.
 *
 * Restoring from a backup is performed by creating a new EC2 instance. If restoration is successful, and the server is in a `HEALTHY` state, AWS OpsWorks CM switches traffic over to the new instance. After restoration is finished, the old EC2 instance is maintained in a `Running` or `Stopped` state, but is eventually terminated.
 *
 *  This operation is asynchronous.
 *
 *  An `InvalidStateException` is thrown when the server is not in a valid state. A `ResourceNotFoundException` is thrown when the server does not exist. A `ValidationException` is raised when parameters of the request are not valid.
 */
public suspend inline fun OpsWorksCmClient.restoreServer(crossinline block: RestoreServerRequest.Builder.() -> Unit): RestoreServerResponse = restoreServer(RestoreServerRequest.Builder().apply(block).build())

/**
 * Manually starts server maintenance. This command can be useful if an earlier maintenance attempt failed, and the underlying cause of maintenance failure has been resolved. The server is in an `UNDER_MAINTENANCE` state while maintenance is in progress.
 *
 *  Maintenance can only be started on servers in `HEALTHY` and `UNHEALTHY` states. Otherwise, an `InvalidStateException` is thrown. A `ResourceNotFoundException` is thrown when the server does not exist. A `ValidationException` is raised when parameters of the request are not valid.
 */
public suspend inline fun OpsWorksCmClient.startMaintenance(crossinline block: StartMaintenanceRequest.Builder.() -> Unit): StartMaintenanceResponse = startMaintenance(StartMaintenanceRequest.Builder().apply(block).build())

/**
 * Applies tags to an AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise server, or to server backups.
 */
public suspend inline fun OpsWorksCmClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes specified tags from an AWS OpsWorks-CM server or backup.
 */
public suspend inline fun OpsWorksCmClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates settings for a server.
 *
 *  This operation is synchronous.
 */
public suspend inline fun OpsWorksCmClient.updateServer(crossinline block: UpdateServerRequest.Builder.() -> Unit): UpdateServerResponse = updateServer(UpdateServerRequest.Builder().apply(block).build())

/**
 * Updates engine-specific attributes on a specified server. The server enters the `MODIFYING` state when this operation is in progress. Only one update can occur at a time. You can use this command to reset a Chef server's public key (`CHEF_PIVOTAL_KEY`) or a Puppet server's admin password (`PUPPET_ADMIN_PASSWORD`).
 *
 *  This operation is asynchronous.
 *
 *  This operation can only be called for servers in `HEALTHY` or `UNHEALTHY` states. Otherwise, an `InvalidStateException` is raised. A `ResourceNotFoundException` is thrown when the server does not exist. A `ValidationException` is raised when parameters of the request are not valid.
 */
public suspend inline fun OpsWorksCmClient.updateServerEngineAttributes(crossinline block: UpdateServerEngineAttributesRequest.Builder.() -> Unit): UpdateServerEngineAttributesResponse = updateServerEngineAttributes(UpdateServerEngineAttributesRequest.Builder().apply(block).build())
