// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworkscm.waiters

import aws.sdk.kotlin.services.opsworkscm.OpsWorksCmClient
import aws.sdk.kotlin.services.opsworkscm.model.DescribeNodeAssociationStatusRequest
import aws.sdk.kotlin.services.opsworkscm.model.DescribeNodeAssociationStatusResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until node is associated or disassociated.
 */
public suspend fun OpsWorksCmClient.waitUntilNodeAssociated(request: DescribeNodeAssociationStatusRequest): Outcome<DescribeNodeAssociationStatusResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeNodeAssociationStatusRequest, DescribeNodeAssociationStatusResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val nodeAssociationStatus = it?.nodeAssociationStatus
            nodeAssociationStatus?.toString() == "SUCCESS"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val nodeAssociationStatus = it?.nodeAssociationStatus
            nodeAssociationStatus?.toString() == "FAILED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeNodeAssociationStatus(request) }
}

/**
 * Wait until node is associated or disassociated.
 */
public suspend fun OpsWorksCmClient.waitUntilNodeAssociated(block: DescribeNodeAssociationStatusRequest.Builder.() -> Unit): Outcome<DescribeNodeAssociationStatusResponse> =
    waitUntilNodeAssociated(DescribeNodeAssociationStatusRequest.Builder().apply(block).build())
