// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworkscm.transform

import aws.sdk.kotlin.services.opsworkscm.model.AssociateNodeResponse
import aws.sdk.kotlin.services.opsworkscm.model.OpsWorksCmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class AssociateNodeOperationDeserializer: HttpDeserialize<AssociateNodeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AssociateNodeResponse {
        if (!response.status.isSuccess()) {
            throwAssociateNodeError(context, response)
        }
        val builder = AssociateNodeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAssociateNodeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwAssociateNodeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OpsWorksCmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidStateException" -> InvalidStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OpsWorksCmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAssociateNodeOperationBody(builder: AssociateNodeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NODEASSOCIATIONSTATUSTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NodeAssociationStatusToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NODEASSOCIATIONSTATUSTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NODEASSOCIATIONSTATUSTOKEN_DESCRIPTOR.index -> builder.nodeAssociationStatusToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
