// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworkscm.model



public class ExportServerEngineAttributeRequest private constructor(builder: Builder) {
    /**
     * The name of the export attribute. Currently, the supported export attribute is `Userdata`. This exports a user data script that includes parameters and values provided in the `InputAttributes` list.
     */
    public val exportAttributeName: kotlin.String? = builder.exportAttributeName
    /**
     * The list of engine attributes. The list type is `EngineAttribute`. An `EngineAttribute` list item is a pair that includes an attribute name and its value. For the `Userdata` ExportAttributeName, the following are supported engine attribute names.
     * + **RunList** In Chef, a list of roles or recipes that are run in the specified order. In Puppet, this parameter is ignored.
     * + **OrganizationName** In Chef, an organization name. AWS OpsWorks for Chef Automate always creates the organization `default`. In Puppet, this parameter is ignored.
     * + **NodeEnvironment** In Chef, a node environment (for example, development, staging, or one-box). In Puppet, this parameter is ignored.
     * + **NodeClientVersion** In Chef, the version of the Chef engine (three numbers separated by dots, such as 13.8.5). If this attribute is empty, OpsWorks for Chef Automate uses the most current version. In Puppet, this parameter is ignored.
     */
    public val inputAttributes: List<EngineAttribute>? = builder.inputAttributes
    /**
     * The name of the server from which you are exporting the attribute.
     */
    public val serverName: kotlin.String? = builder.serverName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworkscm.model.ExportServerEngineAttributeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportServerEngineAttributeRequest(")
        append("exportAttributeName=$exportAttributeName,")
        append("inputAttributes=$inputAttributes,")
        append("serverName=$serverName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = exportAttributeName?.hashCode() ?: 0
        result = 31 * result + (inputAttributes?.hashCode() ?: 0)
        result = 31 * result + (serverName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportServerEngineAttributeRequest

        if (exportAttributeName != other.exportAttributeName) return false
        if (inputAttributes != other.inputAttributes) return false
        if (serverName != other.serverName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworkscm.model.ExportServerEngineAttributeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the export attribute. Currently, the supported export attribute is `Userdata`. This exports a user data script that includes parameters and values provided in the `InputAttributes` list.
         */
        public var exportAttributeName: kotlin.String? = null
        /**
         * The list of engine attributes. The list type is `EngineAttribute`. An `EngineAttribute` list item is a pair that includes an attribute name and its value. For the `Userdata` ExportAttributeName, the following are supported engine attribute names.
         * + **RunList** In Chef, a list of roles or recipes that are run in the specified order. In Puppet, this parameter is ignored.
         * + **OrganizationName** In Chef, an organization name. AWS OpsWorks for Chef Automate always creates the organization `default`. In Puppet, this parameter is ignored.
         * + **NodeEnvironment** In Chef, a node environment (for example, development, staging, or one-box). In Puppet, this parameter is ignored.
         * + **NodeClientVersion** In Chef, the version of the Chef engine (three numbers separated by dots, such as 13.8.5). If this attribute is empty, OpsWorks for Chef Automate uses the most current version. In Puppet, this parameter is ignored.
         */
        public var inputAttributes: List<EngineAttribute>? = null
        /**
         * The name of the server from which you are exporting the attribute.
         */
        public var serverName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworkscm.model.ExportServerEngineAttributeRequest) : this() {
            this.exportAttributeName = x.exportAttributeName
            this.inputAttributes = x.inputAttributes
            this.serverName = x.serverName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworkscm.model.ExportServerEngineAttributeRequest = ExportServerEngineAttributeRequest(this)
    }
}
