// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworkscm.model



public class AssociateNodeRequest private constructor(builder: Builder) {
    /**
     * Engine attributes used for associating the node.
     *
     * **Attributes accepted in a AssociateNode request for Chef**
     * + `CHEF_ORGANIZATION`: The Chef organization with which the node is associated. By default only one organization named `default` can exist.
     * + `CHEF_NODE_PUBLIC_KEY`: A PEM-formatted public key. This key is required for the `chef-client` agent to access the Chef API.
     *
     * **Attributes accepted in a AssociateNode request for Puppet**
     * + `PUPPET_NODE_CSR`: A PEM-formatted certificate-signing request (CSR) that is created by the node.
     */
    public val engineAttributes: List<EngineAttribute>? = builder.engineAttributes
    /**
     * The name of the node.
     */
    public val nodeName: kotlin.String? = builder.nodeName
    /**
     * The name of the server with which to associate the node.
     */
    public val serverName: kotlin.String? = builder.serverName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworkscm.model.AssociateNodeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssociateNodeRequest(")
        append("engineAttributes=$engineAttributes,")
        append("nodeName=$nodeName,")
        append("serverName=$serverName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = engineAttributes?.hashCode() ?: 0
        result = 31 * result + (nodeName?.hashCode() ?: 0)
        result = 31 * result + (serverName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssociateNodeRequest

        if (engineAttributes != other.engineAttributes) return false
        if (nodeName != other.nodeName) return false
        if (serverName != other.serverName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworkscm.model.AssociateNodeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Engine attributes used for associating the node.
         *
         * **Attributes accepted in a AssociateNode request for Chef**
         * + `CHEF_ORGANIZATION`: The Chef organization with which the node is associated. By default only one organization named `default` can exist.
         * + `CHEF_NODE_PUBLIC_KEY`: A PEM-formatted public key. This key is required for the `chef-client` agent to access the Chef API.
         *
         * **Attributes accepted in a AssociateNode request for Puppet**
         * + `PUPPET_NODE_CSR`: A PEM-formatted certificate-signing request (CSR) that is created by the node.
         */
        public var engineAttributes: List<EngineAttribute>? = null
        /**
         * The name of the node.
         */
        public var nodeName: kotlin.String? = null
        /**
         * The name of the server with which to associate the node.
         */
        public var serverName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworkscm.model.AssociateNodeRequest) : this() {
            this.engineAttributes = x.engineAttributes
            this.nodeName = x.nodeName
            this.serverName = x.serverName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworkscm.model.AssociateNodeRequest = AssociateNodeRequest(this)
    }
}
