// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearchserverless.transform

import aws.sdk.kotlin.services.opensearchserverless.model.AccessPolicyStats
import aws.sdk.kotlin.services.opensearchserverless.model.GetPoliciesStatsResponse
import aws.sdk.kotlin.services.opensearchserverless.model.OpenSearchServerlessException
import aws.sdk.kotlin.services.opensearchserverless.model.SecurityConfigStats
import aws.sdk.kotlin.services.opensearchserverless.model.SecurityPolicyStats
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetPoliciesStatsOperationDeserializer: HttpDeserialize<GetPoliciesStatsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetPoliciesStatsResponse {
        if (!response.status.isSuccess()) {
            throwGetPoliciesStatsError(context, response)
        }
        val builder = GetPoliciesStatsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetPoliciesStatsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetPoliciesStatsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OpenSearchServerlessException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OpenSearchServerlessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPoliciesStatsOperationBody(builder: GetPoliciesStatsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCESSPOLICYSTATS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AccessPolicyStats"))
    val SECURITYCONFIGSTATS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SecurityConfigStats"))
    val SECURITYPOLICYSTATS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SecurityPolicyStats"))
    val TOTALPOLICYCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("TotalPolicyCount"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSPOLICYSTATS_DESCRIPTOR)
        field(SECURITYCONFIGSTATS_DESCRIPTOR)
        field(SECURITYPOLICYSTATS_DESCRIPTOR)
        field(TOTALPOLICYCOUNT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSPOLICYSTATS_DESCRIPTOR.index -> builder.accessPolicyStats = deserializeAccessPolicyStatsDocument(deserializer)
                SECURITYCONFIGSTATS_DESCRIPTOR.index -> builder.securityConfigStats = deserializeSecurityConfigStatsDocument(deserializer)
                SECURITYPOLICYSTATS_DESCRIPTOR.index -> builder.securityPolicyStats = deserializeSecurityPolicyStatsDocument(deserializer)
                TOTALPOLICYCOUNT_DESCRIPTOR.index -> builder.totalPolicyCount = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
