// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearchserverless.serde

import aws.sdk.kotlin.services.opensearchserverless.model.BatchGetVpcEndpointResponse
import aws.sdk.kotlin.services.opensearchserverless.model.OpenSearchServerlessException
import aws.sdk.kotlin.services.opensearchserverless.model.VpcEndpointDetail
import aws.sdk.kotlin.services.opensearchserverless.model.VpcEndpointErrorDetail
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchGetVpcEndpointOperationDeserializer: HttpDeserializer.NonStreaming<BatchGetVpcEndpointResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchGetVpcEndpointResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchGetVpcEndpointError(context, call, payload)
        }
        val builder = BatchGetVpcEndpointResponse.Builder()

        if (payload != null) {
            deserializeBatchGetVpcEndpointOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchGetVpcEndpointError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw OpenSearchServerlessException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> OpenSearchServerlessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetVpcEndpointOperationBody(builder: BatchGetVpcEndpointResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val VPCENDPOINTDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("vpcEndpointDetails"))
    val VPCENDPOINTERRORDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("vpcEndpointErrorDetails"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(VPCENDPOINTDETAILS_DESCRIPTOR)
        field(VPCENDPOINTERRORDETAILS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                VPCENDPOINTDETAILS_DESCRIPTOR.index -> builder.vpcEndpointDetails =
                    deserializer.deserializeList(VPCENDPOINTDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<VpcEndpointDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeVpcEndpointDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VPCENDPOINTERRORDETAILS_DESCRIPTOR.index -> builder.vpcEndpointErrorDetails =
                    deserializer.deserializeList(VPCENDPOINTERRORDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<VpcEndpointErrorDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeVpcEndpointErrorDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
